/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lorne.weixin.pay.api.AbstractWxPay;
import com.lorne.weixin.pay.model.CertificateEntity;
import com.lorne.weixin.pay.model.SubmitReqData;
import com.lorne.weixin.pay.model.UpdateSubmitReqData;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.nutils.WeixinApplyUtils;
import com.lorne.weixin.pay.util.AesGcmExample2;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class WxMerchantAppy
extends AbstractWxPay {
    public WxMerchantAppy() {
    }

    public WxMerchantAppy(WxConfig wxConfig) {
        super(wxConfig);
    }

    public String uploadMedia(File file) throws Exception {
        Map<String, Object> map = WeixinApplyUtils.upload(this.getPayUrl(), this.wxConfig, file);
        if (Objects.nonNull(map)) {
            String return_code = (String)map.get("return_code");
            String result_code = (String)map.get("result_code");
            String return_msg = (String)map.get("return_msg");
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(result_code)) {
                String mediaId = (String)map.get("media_id");
                return mediaId;
            }
            String err_code_des = (String)map.get("err_code_des");
            String err_msg = "[" + map.get("err_code") + "]" + map.get("err_code_des");
            throw new Exception("\u5fae\u4fe1\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff1a" + (!StringUtils.isBlank((String)err_code_des) ? return_msg : err_msg));
        }
        throw new Exception("\u8c03\u7528\u5fae\u4fe1\u4e0a\u4f20\u56fe\u7247\u5931\u8d25");
    }

    public CertificateEntity getcertficates() throws Exception {
        Map<String, Object> map = WeixinApplyUtils.getcertficates(this.getPayUrl(), this.wxConfig);
        if (Objects.nonNull(map)) {
            String return_code = (String)map.get("return_code");
            String result_code = (String)map.get("result_code");
            String return_msg = (String)map.get("return_msg");
            if ("SUCCESS".equals(return_code) && "SUCCESS".equals(result_code)) {
                JSONObject certificates = JSONObject.parseObject((String)((String)map.get("certificates")));
                JSONArray data = JSONObject.parseArray((String)certificates.getString("data"));
                Map certificateMap = new HashMap();
                if (data != null && !data.isEmpty()) {
                    certificateMap = (Map)data.get(0);
                }
                String serial_no = (String)certificateMap.get("serial_no");
                String effective_time = (String)certificateMap.get("effective_time");
                String expire_time = (String)certificateMap.get("expire_time");
                JSONObject encrypt_certificate = (JSONObject)certificateMap.get("encrypt_certificate");
                String algorithm = (String)encrypt_certificate.get((Object)"algorithm");
                String nonce = (String)encrypt_certificate.get((Object)"nonce");
                String associated_data = (String)encrypt_certificate.get((Object)"associated_data");
                String ciphertext = (String)encrypt_certificate.get((Object)"ciphertext");
                String cert = AesGcmExample2.aesgcmDecrypt(this.wxConfig.getV3key(), associated_data, nonce, ciphertext);
                CertificateEntity certificateEntity = new CertificateEntity(serial_no, effective_time, expire_time, algorithm, nonce, associated_data, ciphertext, cert);
                return certificateEntity;
            }
            String err_code_des = (String)map.get("err_code_des");
            String err_msg = "[" + map.get("err_code") + "]" + map.get("err_code_des");
            throw new Exception("\u5fae\u4fe1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff1a" + (!StringUtils.isBlank((String)err_code_des) ? return_msg : err_msg));
        }
        throw new Exception("\u8c03\u7528\u5fae\u4fe1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25");
    }

    public Map<String, Object> submit(String cert_sn, String business_code, String id_card_copy, String id_card_national, String id_card_name, String id_card_number, String id_card_valid_time, String account_name, String account_bank, String bank_address_code, String bank_name, String account_number, String store_name, String store_address_code, String store_street, String store_entrance_pic, String indoor_pic, String address_certification, String merchant_shortname, String service_phone, String product_desc, String contact, String contact_phone, String contact_email) {
        return WeixinApplyUtils.submit(this.wxConfig, this.getPayUrl(), new SubmitReqData(this.wxConfig.getMchId(), this.wxConfig.getRate(), this.wxConfig.getKey(), cert_sn, business_code, id_card_copy, id_card_national, id_card_name, id_card_number, id_card_valid_time, account_name, account_bank, bank_address_code, bank_name, account_number, store_name, store_address_code, store_street, store_entrance_pic, indoor_pic, address_certification, merchant_shortname, service_phone, product_desc, contact, contact_phone, contact_email));
    }

    public Map<String, Object> getstate(String applyment_id, String business_code) {
        return WeixinApplyUtils.getstate(this.getPayUrl(), this.wxConfig, applyment_id, business_code);
    }

    public Map<String, Object> submitupgrade(String cert_sn, String sub_mch_id, String organization_type, String business_license_copy, String business_license_number, String merchant_name, String company_address, String legal_person, String business_time, String business_licence_type, String merchant_shortname, String business_scene) {
        return WeixinApplyUtils.submitupgrade(this.getPayUrl(), new UpdateSubmitReqData(this.wxConfig, cert_sn, sub_mch_id, organization_type, business_license_copy, business_license_number, merchant_name, company_address, legal_person, business_time, business_licence_type, merchant_shortname, this.wxConfig.getRate(), business_scene));
    }

    public Map<String, Object> getupgradestate(String sub_mch_id) {
        return WeixinApplyUtils.getupgradestate(this.getPayUrl(), this.wxConfig, sub_mch_id);
    }
}

