/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.model;

import com.lorne.weixin.pay.model.MapXml;
import com.lorne.weixin.pay.util.Signature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class UploadReqData
extends MapXml {
    private String mch_id;
    private String media;
    private String media_hash;
    private String sign;
    private String sign_type = "HMAC-SHA256";

    public UploadReqData(String key, String mchId, File file) {
        this.mch_id = mchId;
        this.media_hash = UploadReqData.md5HashCode(file);
        this.setSign(Signature.getSign(this.toMap(), key));
        this.media = file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5HashCode(File file) {
        FileInputStream fis = null;
        try {
            int length;
            fis = new FileInputStream(file);
            MessageDigest MD52 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((length = fis.read(buffer)) != -1) {
                MD52.update(buffer, 0, length);
            }
            String string = new String(Hex.encodeHex((byte[])MD52.digest()));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MultipartEntityBuilder multipartEntityBuilder(File file) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addTextBody("mch_id", this.mch_id, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addBinaryBody("media", file, ContentType.create((String)"image/jpg"), this.getMedia());
        multipartEntityBuilder.addTextBody("media_hash", this.media_hash, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addTextBody("sign_type", this.sign_type, ContentType.MULTIPART_FORM_DATA);
        multipartEntityBuilder.addTextBody("sign", this.sign, ContentType.MULTIPART_FORM_DATA);
        return multipartEntityBuilder;
    }

    public String getMch_id() {
        return this.mch_id;
    }

    public String getMedia() {
        return this.media;
    }

    public String getMedia_hash() {
        return this.media_hash;
    }

    public String getSign() {
        return this.sign;
    }

    public String getSign_type() {
        return this.sign_type;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public void setMedia_hash(String media_hash) {
        this.media_hash = media_hash;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setSign_type(String sign_type) {
        this.sign_type = sign_type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadReqData)) {
            return false;
        }
        UploadReqData other = (UploadReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mch_id = this.getMch_id();
        String other$mch_id = other.getMch_id();
        if (this$mch_id == null ? other$mch_id != null : !this$mch_id.equals(other$mch_id)) {
            return false;
        }
        String this$media = this.getMedia();
        String other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        String this$media_hash = this.getMedia_hash();
        String other$media_hash = other.getMedia_hash();
        if (this$media_hash == null ? other$media_hash != null : !this$media_hash.equals(other$media_hash)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$sign_type = this.getSign_type();
        String other$sign_type = other.getSign_type();
        return !(this$sign_type == null ? other$sign_type != null : !this$sign_type.equals(other$sign_type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadReqData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mch_id = this.getMch_id();
        result = result * 59 + ($mch_id == null ? 43 : $mch_id.hashCode());
        String $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        String $media_hash = this.getMedia_hash();
        result = result * 59 + ($media_hash == null ? 43 : $media_hash.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $sign_type = this.getSign_type();
        result = result * 59 + ($sign_type == null ? 43 : $sign_type.hashCode());
        return result;
    }

    public String toString() {
        return "UploadReqData(mch_id=" + this.getMch_id() + ", media=" + this.getMedia() + ", media_hash=" + this.getMedia_hash() + ", sign=" + this.getSign() + ", sign_type=" + this.getSign_type() + ")";
    }

    public UploadReqData() {
    }

    public UploadReqData(String mch_id, String media, String media_hash, String sign, String sign_type) {
        this.mch_id = mch_id;
        this.media = media;
        this.media_hash = media_hash;
        this.sign = sign;
        this.sign_type = sign_type;
    }
}

