/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.nutils;

import com.alibaba.fastjson.JSONObject;
import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.CertficatesReqData;
import com.lorne.weixin.pay.model.GetSubmitReqData;
import com.lorne.weixin.pay.model.GetUpdateSubmitReqData;
import com.lorne.weixin.pay.model.SubmitReqData;
import com.lorne.weixin.pay.model.UpdateSubmitReqData;
import com.lorne.weixin.pay.model.UploadReqData;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.util.HttpsRequest;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.XMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class WeixinApplyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeixinApplyUtils.class);
    public static String UPLOAD_MEDIA = "/secapi/mch/uploadmedia";
    public static String GET_CERTFICATES = "/risk/getcertficates";
    public static String SUBMIT = "/applyment/micro/submit";
    public static String GET_SUBMIT_STATE = "/applyment/micro/getstate";
    public static String SUBMIT_UPGRADE = "/applyment/micro/submitupgrade";
    public static String GET_SUBMIT_UPGRADE_STATE = "/applyment/micro/getupgradestate";

    public static Map<String, Object> upload(String url, WxConfig config, File file) {
        try {
            UploadReqData uploadReqData = new UploadReqData(config.getKey(), config.getMchId(), file);
            LogUtils.logResult("\u5b98\u65b9\u5fae\u4fe1--\u4e0a\u4f20\u56fe\u7247\u8bf7\u6c42\u53c2\u6570\uff1a{}", JSONObject.toJSONString((Object)uploadReqData));
            MultipartEntityBuilder multipartEntityBuilder = uploadReqData.multipartEntityBuilder(file);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            File certFile = ResourceUtils.getFile((String)("classpath:" + config.getCertLocalPath()));
            FileInputStream instream = new FileInputStream(certFile);
            keyStore.load(instream, config.getMchId().toCharArray());
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, config.getMchId().toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost httpPost = new HttpPost(url + UPLOAD_MEDIA);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-Type", "multipart/form-data; charset=UTF-8");
            httpPost.addHeader("User-Agent", "wxpay sdk java v1.0 " + config);
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            LogUtils.logResult("\u5b98\u65b9\u5fae\u4fe1--\u4e0a\u4f20\u56fe\u7247\u8fd4\u56de\u7ed3\u679c\uff1a{}", result);
            return XMLParser.getMapFromXML(result);
        }
        catch (Exception e) {
            LOGGER.error("\u5b98\u65b9\u5fae\u4fe1--\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> getcertficates(String url, WxConfig config) {
        CertficatesReqData certficatesReqData = new CertficatesReqData(config.getKey(), config.getMchId());
        String postDataXML = certficatesReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u83b7\u53d6\u5546\u6237\u5e73\u53f0\u8bc1\u4e66", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + GET_CERTFICATES), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u83b7\u53d6\u5546\u6237\u5e73\u53f0\u8bc1\u4e66", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> submit(WxConfig wxConfig, String url, SubmitReqData submitReqData) {
        String postDataXML = submitReqData.toXml();
        LogUtils.logResult("\u7533\u8bf7\u5165\u9a7b", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(wxConfig);
            String res = httpsRequest.sendPost(url + SUBMIT, postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7533\u8bf7\u5165\u9a7b", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getstate(String url, WxConfig wxConfig, String applyment_id, String business_code) {
        String postDataXML = new GetSubmitReqData(wxConfig, applyment_id, business_code).toXml();
        LogUtils.logResult("\u67e5\u8be2\u7533\u8bf7\u72b6\u6001", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(wxConfig);
            String res = httpsRequest.sendPost(url + GET_SUBMIT_STATE, postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7533\u8bf7\u72b6\u6001", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> submitupgrade(String url, UpdateSubmitReqData updateSubmitReqData) {
        String postDataXML = updateSubmitReqData.toXml();
        LogUtils.logResult("\u63d0\u4ea4\u5347\u7ea7\u7533\u8bf7\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + SUBMIT_UPGRADE), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u5347\u7ea7\u7533\u8bf7\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getupgradestate(String url, WxConfig wxConfig, String sub_mch_id) {
        String postDataXML = new GetUpdateSubmitReqData(wxConfig, sub_mch_id).toXml();
        LogUtils.logResult("\u67e5\u8be2\u5347\u7ea7\u7533\u8bf7\u5355\u72b6\u6001", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + GET_SUBMIT_UPGRADE_STATE), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u5347\u7ea7\u7533\u8bf7\u5355\u72b6\u6001", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

