/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.nutils;

import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.CheckBillReqData;
import com.lorne.weixin.pay.model.CloseOrderReqData;
import com.lorne.weixin.pay.model.MicroPayReqData;
import com.lorne.weixin.pay.model.RefundQueryReqData;
import com.lorne.weixin.pay.model.RefundReqData;
import com.lorne.weixin.pay.model.ReverseOrderReqData;
import com.lorne.weixin.pay.model.ScanPayQueryReqData;
import com.lorne.weixin.pay.model.UnifiedorderPayReqData;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.util.HttpsRequest;
import com.lorne.weixin.pay.util.LogUtils;
import com.lorne.weixin.pay.util.XMLParser;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinPayUtils {
    private static Logger logger = LoggerFactory.getLogger(WeixinPayUtils.class);
    public static final String PAY_UNFIFIEDORDER = "/pay/unifiedorder";
    public static final String PAY_MICROPAY = "/pay/micropay";
    public static final String PAY_QUERY_API = "/pay/orderquery";
    public static final String PAY_REFUND_API = "/secapi/pay/refund";
    public static final String PAY_REFUND_QUERY_API = "/pay/refundquery";
    public static final String PAY_CLOSE_ORDER_API = "/pay/closeorder";
    public static final String PAY_REVERSE_ORDER_API = "/secapi/pay/reverse";
    public static final String PAY_DOWNLOADBILL_API = "/pay/downloadbill";

    public static Map<String, Object> payUnifiedorder(String url, WxConfig config, String subMchId, String deviceInfo, String body, int total_fee, String ip, String out_trade_no, String openid, String trade_type) {
        UnifiedorderPayReqData unifiedorderPayReqData = new UnifiedorderPayReqData(config.getKey(), config.getAppId(), config.getMchId(), config.getSubAppid(), subMchId, deviceInfo, body, "", "", out_trade_no, "", total_fee, ip, "", "", "", config.getNotifyUrl(), trade_type, "", openid);
        String postDataXML = unifiedorderPayReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", XMLParser.format(postDataXML));
        try {
            String res = HttpUtils.postXml((String)(url + PAY_UNFIFIEDORDER), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", XMLParser.format(res));
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> paySubUnifiedorder(String url, WxConfig config, String subAppid, String subMchId, String deviceInfo, String body, int total_fee, String ip, String out_trade_no, String openid, String trade_type) {
        UnifiedorderPayReqData unifiedorderPayReqData = new UnifiedorderPayReqData(config.getKey(), config.getAppId(), config.getMchId(), subAppid, subMchId, deviceInfo, body, "", "", out_trade_no, "", total_fee, ip, "", "", "", config.getNotifyUrl(), trade_type, "", openid);
        String postDataXML = unifiedorderPayReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", XMLParser.format(postDataXML));
        try {
            String res = HttpUtils.postXml((String)(url + PAY_UNFIFIEDORDER), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", XMLParser.format(res));
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> payMicropay(String url, WxConfig config, String authCode, String subMchId, String deviceInfo, String body, String outTradeNo, String ip, int totalFee, String timeStart, String timeExpire) {
        MicroPayReqData mPayReqData = new MicroPayReqData(config.getAppId(), config.getMchId(), subMchId, authCode, config.getKey(), deviceInfo, body, outTradeNo, totalFee, ip, timeStart, timeExpire);
        String postDataXML = mPayReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + PAY_MICROPAY), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7edf\u4e00\u4e0b\u5355\u53c2\u6570", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> downLoadBill(String url, WxConfig wxConfig, String subMchId, String bill_date, String bill_type) {
        CheckBillReqData checkBillReqData = new CheckBillReqData(wxConfig.getAppId(), wxConfig.getMchId(), subMchId, wxConfig.getKey(), bill_date, bill_type);
        String postDataXML = checkBillReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u4e0b\u8f7d\u8d26\u5355\u53c2\u6570", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + PAY_DOWNLOADBILL_API), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u4e0b\u8f7d\u8d26\u5355\u53c2\u6570", res);
            HashMap<String, Object> map = new HashMap();
            try {
                map = XMLParser.getMapFromXML(res);
            }
            catch (Exception e) {
                map.put("billDate", res);
                map.put("return_code", "SUCCESS");
            }
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> refund(String url, WxConfig config, String sub_mch_id, String out_trade_no, String out_refund_no, int total_fee, int refund_fee) {
        RefundReqData reqData = new RefundReqData(config.getKey(), config.getAppId(), config.getMchId(), sub_mch_id, out_trade_no, out_refund_no, total_fee, refund_fee, config.getMchId());
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u7533\u8bf7\u9000\u6b3e", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(config);
            String res = httpsRequest.sendPost(url + PAY_REFUND_API, postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u7533\u8bf7\u9000\u6b3e", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> closeOrder(String url, WxConfig config, String sub_mch_id, String out_trade_no) {
        CloseOrderReqData reqData = new CloseOrderReqData(config.getKey(), config.getAppId(), config.getMchId(), sub_mch_id, out_trade_no);
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u5173\u95ed\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + PAY_CLOSE_ORDER_API), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u5173\u95ed\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> refundQuery(String url, WxConfig config, String sub_mch_id, String out_trade_no) {
        RefundQueryReqData reqData = new RefundQueryReqData(config.getKey(), config.getAppId(), config.getMchId(), sub_mch_id, out_trade_no);
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + PAY_REFUND_QUERY_API), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> payOrderquery(String url, WxConfig config, String sub_mch_id, String out_trade_no) {
        ScanPayQueryReqData scanPayQueryReqData = new ScanPayQueryReqData(config, null, sub_mch_id, out_trade_no);
        String postDataXML = scanPayQueryReqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u67e5\u8be2\u8ba2\u5355", postDataXML);
        try {
            String res = HttpUtils.postXml((String)(url + PAY_QUERY_API), (String)postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u67e5\u8be2\u8ba2\u5355", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> reverse(String url, WxConfig wxConfig, String sub_mch_id, String out_trade_no) {
        ReverseOrderReqData reqData = new ReverseOrderReqData(wxConfig.getKey(), wxConfig.getAppId(), wxConfig.getMchId(), sub_mch_id, out_trade_no);
        String postDataXML = reqData.toXml();
        LogUtils.logResult("\u8bf7\u6c42\u64a4\u9500\u8ba2\u5355", postDataXML);
        try {
            HttpsRequest httpsRequest = new HttpsRequest(wxConfig);
            String res = httpsRequest.sendPost(url + PAY_REVERSE_ORDER_API, postDataXML);
            LogUtils.logResult("\u54cd\u5e94\u64a4\u9500", res);
            Map<String, Object> map = XMLParser.getMapFromXML(res);
            return map;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

