/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.nutils;

import com.alibaba.fastjson.JSONObject;
import com.lorne.core.framework.utils.http.HttpUtils;
import com.lorne.weixin.pay.model.TemplateMsg;
import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.util.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinPublicUtils {
    private static Logger logger = LoggerFactory.getLogger(WeixinPublicUtils.class);
    public static final String JSCODE_SESSION_API = "/sns/jscode2session";
    public static final String PAY_ACCESS_TOKEN = "/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    public static final String SEND_MSG = "/cgi-bin/message/wxopen/template/send?access_token=%s";

    public static Map<String, Object> jscode2session(String url, WxConfig config, String jsCode) {
        url = url + JSCODE_SESSION_API + "?appid=" + config.getAppId() + "&secret=" + config.getAppSecret() + "&js_code=" + jsCode + "&grant_type=authorization_code";
        JSONObject map = null;
        String res = HttpUtils.get((String)url);
        LogUtils.logResult("\u83b7\u53d6sessionKey\u4e0eopendId\u8ba2\u5355", res);
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> getAccessToken(String url, WxConfig config) {
        url = String.format(url + PAY_ACCESS_TOKEN, config.getAppId(), config.getAppSecret());
        JSONObject map = null;
        String res = HttpUtils.get((String)url);
        LogUtils.logResult("\u83b7\u53d6ACCESS_TOKEN", res);
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public static Map<String, Object> pushMsg(String url, String accessToken, String touser, String templateId, String formId, List<TemplateMsg> value) {
        url = String.format(url + SEND_MSG, accessToken);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("touser", touser);
        data.put("template_id", templateId);
        data.put("form_id", formId);
        HashMap<String, TemplateMsg> msgs = new HashMap<String, TemplateMsg>();
        for (int i = 0; i < value.size(); ++i) {
            TemplateMsg msg = value.get(i);
            msgs.put("keyword" + (i + 1), msg);
        }
        data.put("data", msgs);
        String json = new JSONObject(data).toJSONString();
        System.out.println(json);
        String res = HttpUtils.postJson((String)url, (String)json);
        LogUtils.logResult("\u53d1\u9001\u6a21\u677f\u6d88\u606f", res);
        JSONObject map = null;
        try {
            map = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }
}

