/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.util;

import com.lorne.core.framework.utils.encode.MD5Util;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signature {
    public static final String HMACSHA256 = "HMAC-SHA256";
    public static final String MD5 = "MD5";

    public static String getSign(Object o, String key) throws IllegalAccessException {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cls = o.getClass();
        for (Field f : fields = cls.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(o) == null || f.get(o) == "") continue;
            list.add(f.getName() + "=" + f.get(o) + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        try {
            result = MD5Util.md5((byte[])result.getBytes("utf-8")).toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return result;
    }

    public static String getSign(Map<String, Object> map, String key) {
        String sign_type = (String)map.get("sign_type");
        if (HMACSHA256.equals(sign_type)) {
            return Signature.getHmacSHA256(map, key);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == "") continue;
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        try {
            result = MD5Util.md5((byte[])result.getBytes("utf-8")).toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return result;
    }

    public static String getHmacSHA256(Map<String, Object> map, String key) {
        HashMap<String, String> params = new HashMap<String, String>();
        Set<String> set = map.keySet();
        for (String string : set) {
            if (map.get(string).equals("")) continue;
            params.put(string, String.valueOf(map.get(string)));
        }
        String string1 = Signature.createSign(params);
        String stringSignTemp = string1 + "&key=" + key;
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            return Signature.byteArrayToHexString(sha256_HMAC.doFinal(stringSignTemp.getBytes("utf-8"))).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    private static String createSign(Map<String, String> params) {
        Set<String> keysSet = params.keySet();
        Object[] keys = keysSet.toArray();
        Arrays.sort(keys);
        StringBuffer temp = new StringBuffer();
        boolean first = true;
        for (Object key : keys) {
            if (first) {
                first = false;
            } else {
                temp.append("&");
            }
            temp.append(key.toString()).append("=");
            String value = params.get(key);
            String valueString = "";
            if (null != value) {
                valueString = value.toString();
            }
            temp.append(valueString);
        }
        return temp.toString();
    }
}

