/*
 * Decompiled with CFR 0.152.
 */
package com.lorne.weixin.pay.wxUtil;

import com.lorne.weixin.pay.model.WxConfig;
import com.lorne.weixin.pay.wxUtil.WXPayXmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.KeyStore;
import java.util.SortedMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXPayHttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WXPayHttpUtil.class);
    private static final String UTFCHARSET = "UTF-8";
    private static final String XMLCONTENT = "text/xml;charset=utf-8";
    private static final String FORMCONTENT = "multipart/form-data;charset=utf-8";

    public static String WXHttpPostFormWithCert(String url, String mcdId, String certPath, MultipartEntityBuilder builder) {
        StringBuilder stringBuilder;
        block65: {
            HttpPost uploadFile = new HttpPost(url);
            SSLConnectionSocketFactory sslsf = null;
            stringBuilder = new StringBuilder();
            ClassLoader classLoader = WXPayHttpUtil.class.getClassLoader();
            URL resource = classLoader.getResource(certPath);
            try (FileInputStream pkcfile = new FileInputStream(new File(resource.getPath()));){
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(pkcfile, mcdId.toCharArray());
                SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mcdId.toCharArray()).build();
                sslsf = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage());
                return "";
            }
            HttpEntity multipart = builder.build();
            uploadFile.setEntity(multipart);
            uploadFile.setHeader("Content-Type", FORMCONTENT);
            try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)uploadFile);){
                if (response == null || response.getEntity() == null) break block65;
                HttpEntity entity = response.getEntity();
                try (InputStream in = entity.getContent();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTFCHARSET));){
                    reader.lines().forEach(line -> stringBuilder.append((String)line));
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
                return "";
            }
        }
        return stringBuilder.toString();
    }

    public static String WXHttpPostXMLWithoutCert(String url, SortedMap<String, String> reqDataTo) {
        StringBuilder stringBuilder;
        block50: {
            HttpPost httpPost = new HttpPost(url);
            StringEntity postEntity = new StringEntity(WXPayXmlUtil.parseMapToXML(reqDataTo), UTFCHARSET);
            httpPost.setHeader("Content-Type", XMLCONTENT);
            httpPost.setEntity((HttpEntity)postEntity);
            stringBuilder = new StringBuilder();
            try (CloseableHttpClient client = HttpClients.createDefault();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                if (response == null || response.getEntity() == null) break block50;
                HttpEntity entity = response.getEntity();
                try (InputStream in = entity.getContent();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTFCHARSET));){
                    reader.lines().forEach(line -> stringBuilder.append((String)line));
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
                return "";
            }
        }
        return stringBuilder.toString();
    }

    public static String WXHttpPostXMLWithCert(String url, SortedMap<String, String> reqData, String certPath) {
        StringBuilder stringBuilder;
        block65: {
            HttpPost queryState = new HttpPost(url);
            SSLConnectionSocketFactory sslsf = null;
            String currentPath = Thread.currentThread().getContextClassLoader().getResource(certPath).getPath();
            ClassLoader classLoader = WxConfig.class.getClassLoader();
            URL resource = classLoader.getResource(certPath);
            try (FileInputStream pkcfile = new FileInputStream(new File(resource.getPath()));){
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(pkcfile, ((String)reqData.get("mch_id")).toCharArray());
                SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, ((String)reqData.get("mch_id")).toCharArray()).build();
                sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage());
                return "";
            }
            stringBuilder = new StringBuilder();
            StringEntity postEntity = new StringEntity(WXPayXmlUtil.parseMapToXML(reqData), UTFCHARSET);
            queryState.setEntity((HttpEntity)postEntity);
            queryState.setHeader("Content-Type", XMLCONTENT);
            try (CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)queryState);){
                if (response == null || response.getEntity() == null) break block65;
                HttpEntity entity = response.getEntity();
                try (InputStream in = entity.getContent();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTFCHARSET));){
                    reader.lines().forEach(line -> stringBuilder.append((String)line));
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
                return "";
            }
        }
        return stringBuilder.toString();
    }
}

