/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class Md5Utils {
    public static byte[] computeMD5Hash(InputStream is) throws IOException {
        return DigestUtils.md5((InputStream)is);
    }

    public static String md5AsBase64(InputStream is) throws IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(is));
    }

    public static byte[] computeMD5Hash(byte[] input) {
        return DigestUtils.md5((byte[])input);
    }

    public static String md5AsBase64(byte[] input) {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(input));
    }

    public static String md5Hex(File file) throws FileNotFoundException, IOException {
        return Hex.encodeHexString((byte[])Md5Utils.computeMD5Hash(file));
    }

    public static String md5Hex(byte[] input) {
        return Hex.encodeHexString((byte[])Md5Utils.computeMD5Hash(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(File file) throws FileNotFoundException, IOException {
        try (FileInputStream input = null;){
            input = new FileInputStream(file);
            byte[] byArray = Md5Utils.computeMD5Hash(input);
            return byArray;
        }
    }

    public static String md5AsBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(file));
    }
}

