/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.mybatis;

import com.github.pagehelper.PageHelper;
import com.ruijc.mybatis.MapperProperties;
import com.ruijc.mybatis.PageHelperProperties;
import com.ruijc.mybatis.cache.SerializerUtils;
import com.ruijc.mybatis.cache.redis.RedisUtils;
import com.ruijc.util.serialize.FSTSerializerImpl;
import com.ruijc.util.serialize.FastjsonSerializerImpl;
import com.ruijc.util.serialize.ISerializer;
import com.ruijc.util.serialize.KryoSerializerImpl;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import tk.mybatis.spring.mapper.MapperScannerConfigurer;

@Configuration
@AutoConfigureAfter(value={org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration.class})
@EnableConfigurationProperties(value={PageHelperProperties.class, MapperProperties.class})
@ComponentScan(basePackageClasses={RedisUtils.class, SerializerUtils.class})
public class MybatisAutoConfiguration {
    @Autowired
    private PageHelperProperties helperProperties;
    @Autowired
    private MapperProperties mapperProperties;

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    @ConditionalOnBean(value={DataSource.class})
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    @ConditionalOnClass(name={"com.github.pagehelper.PageHelper"})
    public PageHelper pageHelper(DataSource dataSource) {
        dataSource = new PageHelper();
        Properties properties = new Properties();
        if (this.helperProperties != null) {
            properties.setProperty("dialect", this.helperProperties.getDialect());
            properties.setProperty("offsetAsPageNum", this.helperProperties.getOffsetAsPageNum());
            properties.setProperty("rowBoundsWithCount", this.helperProperties.getRowBoundsWithCount());
            properties.setProperty("pageSizeZero", this.helperProperties.getPageSizeZero());
            properties.setProperty("reasonable", this.helperProperties.getReasonable());
            properties.setProperty("params", this.helperProperties.getParams());
            properties.setProperty("supportMethodsArguments", this.helperProperties.getSupportMethodsArguments());
            properties.setProperty("returnPageInfo", this.helperProperties.getReturnPageInfo());
            properties.setProperty("closeConn", this.helperProperties.getCloseConn());
        }
        dataSource.setProperties(properties);
        return dataSource;
    }

    @Bean
    @ConditionalOnClass(name={"tk.mybatis.spring.mapper.MapperScannerConfigurer"})
    public MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setSqlSessionFactoryBeanName("sqlSessionFactory");
        mapperScannerConfigurer.setBasePackage("com.isea533.mybatis.mapper");
        Properties properties = new Properties();
        if (this.mapperProperties != null) {
            properties.setProperty("mappers", this.mapperProperties.getMappers());
            properties.setProperty("notEmpty", this.mapperProperties.getNotEmpty());
            properties.setProperty("IDENTITY", this.mapperProperties.getIdentity());
            properties.setProperty("ORDER", this.mapperProperties.getOrder());
            properties.setProperty("catalog", this.mapperProperties.getCatalog());
            properties.setProperty("schema", this.mapperProperties.getSchema());
            properties.setProperty("seqFormat", this.mapperProperties.getSeqFormat());
            properties.setProperty("style", this.mapperProperties.getStyle());
            properties.setProperty("enableMethodAnnotation", this.mapperProperties.getEnableMethodAnnotation());
        }
        mapperScannerConfigurer.setProperties(properties);
        return mapperScannerConfigurer;
    }

    @Bean
    @ConditionalOnClass(name={"com.alibaba.fastjson.JSON"})
    @ConditionalOnProperty(name={"mybatis.cache.serializer.type"}, havingValue="fastjson", matchIfMissing=true)
    public ISerializer<Object> fastjsonSerializer() {
        return new FastjsonSerializerImpl();
    }

    @Bean
    @ConditionalOnClass(name={"com.esotericsoftware.kryo.Kryo"})
    @ConditionalOnProperty(name={"mybatis.cache.serializer.type"}, havingValue="kryo", matchIfMissing=true)
    public ISerializer<Object> kryoSerializer() {
        return new KryoSerializerImpl();
    }

    @Bean
    @ConditionalOnClass(name={"org.nustaq.serialization.FSTConfiguration"})
    @ConditionalOnProperty(name={"mybatis.cache.serializer.type"}, havingValue="fst", matchIfMissing=true)
    public ISerializer<Object> fstSerializer() {
        return new FSTSerializerImpl();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.redis.core.RedisTemplate"})
    @ConditionalOnProperty(name={"mybatis.cache.type"}, havingValue="redis", matchIfMissing=true)
    public RedisTemplate<byte[], byte[]> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        return redisTemplate;
    }
}

