/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.mybatis.cache.redis;

import com.ruijc.mybatis.cache.redis.LoggingRedisMapper;
import com.ruijc.mybatis.cache.redis.RedisMapper;
import com.ruijc.mybatis.cache.redis.RedisMapperProperties;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ibatis.annotations.CacheNamespace;
import org.apache.ibatis.annotations.Mapper;
import org.w3c.dom.Node;

public abstract class BaseProcessor
extends AbstractProcessor {
    public static final String STAFF = "Impl";
    protected Filer filer;
    protected Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected abstract RedisMapperProperties getMapperProperties(TypeElement var1);

    protected abstract Set<Element> getElement(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public final boolean process(Set<? extends TypeElement> object, RoundEnvironment object22) {
        for (Element element : this.getElement((Set<? extends TypeElement>)((Object)object), (RoundEnvironment)object22)) {
            if (ElementKind.INTERFACE != element.getKind()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Only interfaces can be annotated with @%s", RedisMapper.class.getSimpleName()), element);
                return true;
            }
            TypeElement typeElement = (TypeElement)element;
            RedisMapperProperties redisMapperProperties = this.getMapperProperties(typeElement);
            redisMapperProperties = this.makeClass(typeElement, redisMapperProperties);
            this.write(typeElement, (TypeSpec.Builder)redisMapperProperties);
        }
        return true;
    }

    protected void write(TypeElement typeElement, TypeSpec.Builder builder) {
        builder = JavaFile.builder((String)this.getPackageName(typeElement), (TypeSpec)builder.build()).build();
        try {
            builder.writeTo(this.filer);
            return;
        }
        catch (Exception exception) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Make interface has error with @%s or @%s", RedisMapper.class.getSimpleName(), LoggingRedisMapper.class.getSimpleName()), typeElement);
            return;
        }
    }

    protected String getPackageName(TypeElement typeElement) {
        return typeElement.getQualifiedName().toString().replace("." + typeElement.getSimpleName(), "");
    }

    protected TypeSpec.Builder makeClass(TypeElement typeElement, RedisMapperProperties object) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)(typeElement.getSimpleName().toString() + STAFF)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addAnnotation(Mapper.class);
        if (!this.checkXMLFileExist(typeElement)) {
            object = AnnotationSpec.builder(CacheNamespace.class).addMember("flushInterval", "$L", new Object[]{((RedisMapperProperties)((Object)object)).getFlushInterval()}).addMember("implementation", "$L.class", new Object[]{((RedisMapperProperties)((Object)object)).getImplementation()}).addMember("eviction", "$L.class", new Object[]{((RedisMapperProperties)((Object)object)).getEviction()}).addMember("size", "$L", new Object[]{((RedisMapperProperties)((Object)object)).getSize()}).addMember("readWrite", "$L", new Object[]{((RedisMapperProperties)((Object)object)).isReadWrite()}).addMember("blocking", "$L", new Object[]{((RedisMapperProperties)((Object)object)).isBlocking()}).build();
            builder.addAnnotation((AnnotationSpec)object);
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                builder.addSuperinterface(TypeName.get((TypeMirror)typeMirror));
            }
            builder.addSuperinterface(TypeName.get((TypeMirror)typeElement.asType()));
        } else {
            this.updateXML(typeElement, (RedisMapperProperties)((Object)object));
        }
        return builder;
    }

    protected void makeMethod(TypeElement object, TypeSpec.Builder builder) {
        for (Element element : object.getEnclosedElements()) {
            if (ElementKind.METHOD != element.getKind()) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)executableElement.getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)executableElement.getReturnType()));
            for (VariableElement variableElement : executableElement.getParameters()) {
                ParameterSpec.Builder builder3 = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]);
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    builder3.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
                }
                builder2.addParameter(builder3.build());
            }
            for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                builder2.addException(TypeName.get((TypeMirror)typeMirror));
            }
            Iterator<AnnotatedConstruct> iterator = builder2.build();
            builder.addMethod(iterator);
        }
    }

    protected boolean checkXMLFileExist(TypeElement object) {
        boolean bl = false;
        object = this.getXMLFilePath((TypeElement)object);
        object = this.getClass().getResourceAsStream((String)object);
        if (object != null) {
            bl = true;
        }
        return bl;
    }

    protected String getXMLFilePath(TypeElement typeElement) {
        return "/" + typeElement.getQualifiedName().toString().replaceAll(".", "/") + ".xml";
    }

    protected void updateXML(TypeElement typeElement, RedisMapperProperties object) {
        Object object2;
        Object object3 = this.getXMLFilePath(typeElement);
        Object object4 = this.getClass().getResourceAsStream((String)object3);
        if (object4 == null) {
            return;
        }
        object4 = DocumentBuilderFactory.newInstance();
        try {
            object2 = ((DocumentBuilderFactory)object4).newDocumentBuilder();
            object4 = ((DocumentBuilder)object2).parse((String)object3);
        }
        catch (Exception exception) {
            return;
        }
        object2 = object4.getFirstChild();
        Node node = object4.getElementsByTagName("cache").item(0);
        if (node != null) {
            return;
        }
        node = object4.createElement("cache");
        node.setAttribute("type", ((RedisMapperProperties)object).getImplementation().toString());
        node.setAttribute("eviction", ((RedisMapperProperties)object).getEviction().toString());
        node.setAttribute("flushInterval", "" + ((RedisMapperProperties)object).getFlushInterval());
        node.setAttribute("size", "" + ((RedisMapperProperties)object).getSize());
        node.setAttribute("readOnly", "" + ((RedisMapperProperties)object).isReadWrite());
        node.setAttribute("blocking", "" + ((RedisMapperProperties)object).isBlocking());
        object2.appendChild(node);
        object = TransformerFactory.newInstance();
        object4 = new DOMSource((Node)object4);
        object3 = new StreamResult((String)object3);
        try {
            ((TransformerFactory)object).newTransformer().transform((Source)object4, (Result)object3);
            return;
        }
        catch (Exception exception) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Make xml file has some error with @%s or @%s", RedisMapper.class.getSimpleName(), LoggingRedisMapper.class.getSimpleName()), typeElement);
            return;
        }
    }
}

