package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiBmikeceHystrix;
import com.ysscale.api.vo.bmikece.PersonReq;
import com.ysscale.report.square.vo.UserMoney;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @Description:
 * @Param:
 * @return:
 * @Author: zhao
 * @Date: 2019/4/9
 */
@FeignClient(value = "server-ysscale", fallback = ApiBmikeceHystrix.class)
public interface ApiBmikeceClient {

    @RequestMapping(value = "/ysscale/web/bmikece/updateUserMoney", method = RequestMethod.POST)
    boolean updateUserMoney(@RequestBody List<UserMoney> userMoney);

    @RequestMapping(value = "/ysscale/web/bmikece/queryUserMoney", method = RequestMethod.POST)
    UserMoney queryUserMoney(@RequestBody PersonReq personReq);

    @RequestMapping(value = "/ysscale/web/bmikece/findAllUserMoney", method = RequestMethod.POST)
    List<UserMoney> findAllUserMoney();
}
