package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiBrightHystrix;
import com.ysscale.api.vo.MarketerAndUser;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lorne
 * @date 2018/5/23
 * @description
 */
@FeignClient(value = "server-ysscale", fallback = ApiBrightHystrix.class)
public interface ApiBrightClient {

    /**
     * @Description 查询清算信息更新支付宝微信交易金额
     */
    @RequestMapping(value = "/ysscale/web/agent/balance/unBindingByMarketId", method = RequestMethod.POST)
    boolean unBindingByMarketId(@RequestBody MarketerAndUser marketerAndUser);

}
