package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiJobHystrix;
import com.ysscale.framework.domain.Merchant;
import com.ysscale.framework.domain.UserStoreBalanceInfo;
import com.ysscale.framework.model.apply.ApplyData;
import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.model.page.PageQuery;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author lorne
 * @date 2018/5/23
 * @description
 */
@FeignClient(value = "server-ysscale", fallback = ApiJobHystrix.class)
public interface ApiJobClient {

    @RequestMapping(value = "/ysscale/job/queryUser", method = RequestMethod.POST)
    Page<Merchant> queryUser(@RequestBody PageQuery pageQuery);

    @RequestMapping(value = "/ysscale/job/createDayBill", method = RequestMethod.POST)
    boolean createDayBill(@RequestBody List<Merchant> userList);

    @RequestMapping(value = "/ysscale/job/queryUserStoreBalanceInfo", method = RequestMethod.POST)
    Page<UserStoreBalanceInfo> queryUserStoreBalanceInfo(@RequestBody PageQuery pageQuery);

    @RequestMapping(value = "/ysscale/job/aliPayTokenRefresh", method = RequestMethod.POST)
    boolean aliPayTokenRefresh();

    @RequestMapping(value = "/ysscale/job/queryApplication", method = RequestMethod.POST)
    List<ApplyData> queryApplication();
}
