package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiSearchHystrix;
import com.ysscale.api.vo.CheckOrderParm;
import com.ysscale.api.vo.StoreReq;
import com.ysscale.api.vo.UPayMerchantInfo;
import com.ysscale.api.vo.job.UserAgent;
import com.ysscale.api.vo.search.*;
import com.ysscale.framework.domain.Agent;
import com.ysscale.framework.domain.Balance;
import com.ysscale.framework.domain.Merchant;
import com.ysscale.framework.domain.UserStoreBalanceInfo;
import com.ysscale.framework.domain.order.TradeInfo;
import com.ysscale.framework.domain.report.RakebackPlan;
import com.ysscale.framework.model.page.Page;
import com.ysscale.framework.model.page.PageQuery;
import com.ysscale.report.square.vo.BillPageQuery;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author lorne
 * @date 2018/5/23
 * @description
 */
@FeignClient(value = "server-ysscale", fallback = ApiSearchHystrix.class)
public interface ApiSearchClient {

    /**
     * @Description 查询清算信息更新支付宝微信交易金额
     */
    @RequestMapping(value = "/ysscale/search/saveOrUpdateBill", method = RequestMethod.POST)
    boolean saveOrUpdateBill(@RequestBody BillClearVo billClearVo);

    /**
     * @Description: 分页查询支付信息
     */
    @RequestMapping(value = "/ysscale/search/queryPayMsg", method = RequestMethod.POST)
    Page<CheckOrderParm> queryPayMsg(@RequestBody PageQuery pageQuery);

    /**
     * @description: 分页查询银联支付信息
     **/
    @RequestMapping(value = "/ysscale/search/queryUPayMsg", method = RequestMethod.POST)
    Page<UPayMerchantInfo> queryUPayMsg(@RequestBody UPayPageQuery pageQuery);

    /**
     * @Description 商户ID获取商户支付信息
     */
    @RequestMapping(value = "/ysscale/search/getPayMsgByUserIds", method = RequestMethod.POST)
    List<CheckOrderParm> getPayMsgByUserIds(@RequestBody List<Integer> userIds);

    /**
     * @Description 商户手机号获取商户支付信息
     */
    @RequestMapping(value = "/ysscale/search/getPayMsgByMobiles", method = RequestMethod.POST)
    List<CheckOrderParm> getPayMsgByMobiles(@RequestBody List<String> mobiles);

    /**
     * @Description 设备ID获取商户商铺
     */
    @RequestMapping(value = "/ysscale/search/getUserStoreBalanceByBalanceId", method = RequestMethod.POST)
    UserStoreBalanceInfo getUserStoreBalanceByBalanceId(@RequestParam("deviceMac") String deviceMac);

    /**
     * @Description 设备mac获取商户商铺
     */
    @RequestMapping(value = "/ysscale/search/getUserStoreBalanceByMac", method = RequestMethod.POST)
    UserStoreBalanceInfo getUserStoreBalanceByMac(@RequestParam("mac") String mac);

    /**
     * @Description 获取全部商户信息
     */
    @RequestMapping(value = "/ysscale/search/getAllUser", method = RequestMethod.POST)
    List<Merchant> getAllUser();

    /**
     * @Description 查询日志支付结果
     */
    @RequestMapping(value = "/ysscale/search/getPayResult", method = RequestMethod.POST)
    TradeInfo getPayResult(@RequestParam("userId") Integer userId, @RequestParam("balanceId") Integer balanceId, @RequestParam("fid") String fid);

    /**
     * @Description 店铺sid和商户号查询店铺信息
     */
    @RequestMapping(value = "/ysscale/search/getStoreInfoByUserIdAndSid", method = RequestMethod.POST)
    Map<String, String> getStoreInfoByUserIdAndSid(@RequestBody StoreReq storeReq);

    /**
     * @Description 经销商id查询商户和经销商信息
     */
    @RequestMapping(value = "/ysscale/search/getUserAndAgentByUserId", method = RequestMethod.POST)
    UserAgent getUserAndAgentByUserId(@RequestParam("agentId") Integer agentId);

    /**
     * @Description 获取全部经销商信息
     */
    @RequestMapping(value = "/ysscale/search/getAllAgent", method = RequestMethod.POST)
    List<Agent> getAllAgent();

    /**
     * @Description 获取全部分佣方案信息
     */
    @RequestMapping(value = "/ysscale/search/getAllRakebackPlan", method = RequestMethod.POST)
    List<RakebackPlan> getAllRakebackPlan();

    /**
     * @Description: 商户ID和经销商ID查询经销商商户关系
     */
    @RequestMapping(value = "/ysscale/search/findAgentUserByUserIdAndAgentId", method = RequestMethod.POST)
    boolean findAgentUserByUserIdAndAgentId(@RequestBody AgentIdAndUserId agent);

    /**
     * @Description 获取经销商根据经销商ID或经销商手机号码
     */
    @RequestMapping(value = "/ysscale/search/getAgentByIdOrMobile", method = RequestMethod.POST)
    List<Agent> getAgentByIdOrMobile(@RequestBody AgentAndUser agent);

    /**
     * @Description 获取经销商服务商户ID
     */
    @RequestMapping(value = "/ysscale/search/getAgentUserIdsByAgentId", method = RequestMethod.POST)
    List<Integer> getAgentUserIdsByAgentId(@RequestParam("agentId") Integer agentId);

    /**
     * @Description 获取经销商服务商户ID
     */
    @RequestMapping(value = "/ysscale/search/getAgentUserIds", method = RequestMethod.POST)
    List<Integer> getAgentUserIds(@RequestParam("agentId") Integer agentId);

    /**
     * @Description 商户IDs查询商户信息
     */
    @RequestMapping(value = "/ysscale/search/getUserByUserIds", method = RequestMethod.POST)
    Map<String, Merchant> getUserByUserIds(@RequestParam("userIds") List<Integer> userIds);

    /**
     * @Description 设备别名查询支付信息
     */
    @RequestMapping(value = "/ysscale/search/getBalanceByUserIdAndName", method = RequestMethod.POST)
    List<Balance> getBalanceByUserIdAndName(@RequestBody BillPageQuery pageQuery);

    /**
     * @Description 设备mac查询设备信息
     */
    @RequestMapping(value = "/ysscale/search/getBalanceByMac", method = RequestMethod.POST)
    Balance getBalanceByMac(@RequestParam("deviceMac") String deviceMac);

    /**
     * @Description 查询支付宝微信实时交易状态
     */
    @RequestMapping(value = "/ysscale/mobile/user/bill/queryActualTradeInfo", method = RequestMethod.POST)
    CPOrderResultVo queryActualTradeInfo(@RequestBody ThTraderQueryVo user);

    /**
     * @Description 查询商户商铺设备信息
     */
    @RequestMapping(value = "/ysscale/search/getUserStoreBalance", method = RequestMethod.POST)
    List<UserStoreBalanceInfo> getUserStoreBalance();
}
