package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiSocketServiceHystrix;
import com.ysscale.api.vo.UnBingInitInfo;
import com.ysscale.framework.domain.Balance;
import com.ysscale.framework.domain.order.DevicePay;
import com.ysscale.framework.domain.order.DevicePayInfo;
import com.ysscale.framework.domain.order.PayMsgInfo;
import com.ysscale.framework.domain.order.PayParameter;
import com.ysscale.framework.domain.socket.*;
import com.ysscale.framework.exception.SystemException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @ProjectName: ysscale_core
 * @Package: com.yssacle.api.client
 * @ClassName: ApiSocketService
 * @Description: java类作用描述
 * @Author: 王列
 * @CreateDate: 2018/5/29 10:37
 * @UpdateUser: 更新者
 * @UpdateDate: 2018/5/29 10:37
 * @UpdateRemark: 更新说明
 * @Version: 1.0
 */
@FeignClient(value = "server-ysscale", fallback = ApiSocketServiceHystrix.class)
public interface ApiSocketServiceClient {

    @RequestMapping(value = "/ysscale/device/socketService/saveBalance", method = RequestMethod.POST)
    boolean saveBalance(@RequestBody Balance balance);

    @RequestMapping(value = "/ysscale/device/socketService/updateBalance", method = RequestMethod.POST)
    boolean updateBalance(@RequestBody Balance balance);

    @RequestMapping(value = "/ysscale/device/socketService/saveLog", method = RequestMethod.POST)
    boolean saveLog(@RequestBody ResponseInstruct responseInstruct);

    @RequestMapping(value = "/ysscale/device/socketService/saveBatchLog", method = RequestMethod.POST)
    boolean saveBatchLog(@RequestBody List<ResponseInstruct> responsesInstructs);

    @RequestMapping(value = "/ysscale/device/socketService/saveBatchLogParam", method = RequestMethod.POST)
    boolean saveBatchLogParam(@RequestBody BatchLogParam batchLogParam);

    @RequestMapping(value = "/ysscale/device/socketService/findPaymentState", method = RequestMethod.POST)
    boolean findPaymentState(@RequestParam("deviceMac") String deviceMac);

    /**
     * @description: 获取店铺支付信息
     **/
    @Deprecated
    @RequestMapping(value = "/ysscale/device/socketService/findPayInfo", method = RequestMethod.POST)
    Map<String, Object> findPayInfo(@RequestParam("deviceMac") String deviceMac) throws SystemException;

    /**
     * @description: 设备Mac获取设备初始化信息
     **/
    @PostMapping(value = "/ysscale/device/socketService/getDeviceInitInfo")
    DeviceInitInfo getDeviceInitInfo(@RequestParam("mac") String mac);

    @RequestMapping(value = "/ysscale/device/socketService/payOrder", method = RequestMethod.POST)
    void payOrder(@RequestBody PayParameter pp);

    @RequestMapping(value = "/ysscale/device/socketService/cancelOrder", method = RequestMethod.POST)
    DevicePay cancelOrder(@RequestBody PayParameter payParameter);

    @RequestMapping(value = "/ysscale/device/socketService/refund", method = RequestMethod.POST)
    void refund(@RequestBody PayParameter payParameter);

    @RequestMapping(value = "/ysscale/device/socketService/cancelRefund", method = RequestMethod.POST)
    DevicePay cancelRefund(@RequestBody PayParameter payParameter);

    @RequestMapping(value = "/ysscale/device/socketService/updateDeviceState", method = RequestMethod.POST)
    boolean updateDeviceState(@RequestBody ConnectionMsg connectionMsg);

    @RequestMapping(value = "/ysscale/device/socketService/getUserByMac", method = RequestMethod.POST)
    DeviceDetail getUserByMac(@RequestParam("deviceMac") String deviceMac);

    @RequestMapping(value = "/ysscale/device/socketService/getPayMsgByDevicemacAndPaycode", method = RequestMethod.POST)
    PayMsgInfo getPayMsgByDevicemacAndPaycode(@RequestBody PayMsgInfo payMsgInfo);

    @RequestMapping(value = "/ysscale/device/socketService/getLastTimeAndFid", method = RequestMethod.POST)
    DeviceFH getLastTimeAndFid(@RequestParam("deviceMac") String mac);

    @RequestMapping(value = "/ysscale/device/socketService/checkPayInfo", method = RequestMethod.POST)
    DevicePayInfo checkPayInfo(@RequestParam("deviceMac") String mac);

    /**
     * @description: 获取解绑信息
     **/
    @GetMapping(value = "/ysscale/device/socketService/getUnbindInfo")
    UnBingInitInfo getUnbindInfo(@RequestParam("mac") String mac);
}
