package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiSquareHystrix;
import com.ysscale.api.vo.MaidReportRequest;
import com.ysscale.api.vo.search.UserRebateRecord;
import com.ysscale.framework.domain.Agent;
import com.ysscale.framework.domain.Merchant;
import com.ysscale.framework.model.page.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Description:
 * @Param:
 * @return:
 * @Author: zhao
 * @Date: 2019/4/9
 */
@FeignClient(value = "server-ysscale", fallback = ApiSquareHystrix.class)
public interface ApiSquareClient {

    @RequestMapping(value = "/ysscale/square/saveUpdateRebateRecord", method = RequestMethod.POST)
    boolean saveUpdateRebateRecord(List<UserRebateRecord> userRebateRecordList);

    @RequestMapping(value = "/ysscale/square/findRebateRecordTotalMoneyPage", method = RequestMethod.POST)
    Page<UserRebateRecord> findRebateRecordTotalMoneyPage(@RequestBody MaidReportRequest maidReportReq);

    @RequestMapping(value = "/ysscale/square/findRebateRecordByPersonPage", method = RequestMethod.POST)
    Page<UserRebateRecord> findRebateRecordByPersonPage(@RequestBody MaidReportRequest maidReportReq);

    @RequestMapping(value = "/ysscale/square/deleteRebateRecord", method = RequestMethod.POST)
    boolean deleteRebateRecord(@RequestBody MaidReportRequest maidReportReq);

    @RequestMapping(value = "/ysscale/square/deleteRebateRecordInfo", method = RequestMethod.POST)
    boolean deleteRebateRecordInfo(@RequestBody MaidReportRequest maidReportReq);

    @RequestMapping(value = "/ysscale/square/maidReport", method = RequestMethod.POST)
    boolean maidReport(@RequestBody MaidReportRequest maidReportReq);

    @RequestMapping(value = "/ysscale/square/queryUserById", method = RequestMethod.POST)
    Merchant queryUserById(@RequestParam(value = "userId") Integer userId);

    @RequestMapping(value = "/ysscale/square/queryAgentById", method = RequestMethod.POST)
    Agent queryAgentById(@RequestParam(value = "agentId") Integer agentId);
}
