package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApiZuulClientHystrix;
import com.ysscale.framework.domain.zuul.AgentAndDeviceVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lorne
 * @date 2018/5/23
 * @description
 */
@FeignClient(value = "server-ysscale", fallback = ApiZuulClientHystrix.class)
public interface ApiZuulClient {

    /**
     * @Description 解绑设备
     */
    @RequestMapping(value = "/ysscale/web/agent/balance/agentUnBindingDeviceList", method = RequestMethod.POST)
    boolean agentUnBindingDeviceList(@RequestBody AgentAndDeviceVo agentAndDevice);

    /**
     * @Description 解绑设备重定向
     */
    @RequestMapping(value = "/ysscale/web/agent/balance/unBindingForward", method = RequestMethod.POST)
    boolean unBindingForward(@RequestBody AgentAndDeviceVo agentAndDevice);
}
