package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.ApplicationHystrix;
import com.ysscale.api.vo.publicp.PaymentInfo;
import com.ysscale.api.vo.publicp.PaymentStateVo;
import com.ysscale.framework.model.apply.ApplyData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(value = "server-ysscale", fallback = ApplicationHystrix.class)
public interface ApplicationClient {

    /**
     * @Description 修改进件状态
     **/
    @RequestMapping(value = "/ysscale/application/updatePaymentState", method = RequestMethod.POST)
    boolean updatePaymentState(@RequestBody PaymentStateVo paymentStateVo);

    /**
     * @description: 更新签约签约进件信息
     **/
    @RequestMapping(value = "/ysscale/application/updatePaymentInfo", method = RequestMethod.POST)
    boolean updatePaymentInfo(@RequestBody PaymentInfo paymentInfo);

    /**
     * @description: 更新支付审核信息
     **/
    @RequestMapping(value = "/ysscale/application/updatePaymentData", method = RequestMethod.POST)
    boolean updatePaymentData(@RequestBody ApplyData applyData);

    /**
     * @description: 重新获取支付审核信息
     **/
    @GetMapping(value = "/ysscale/application/queryApplyInfoById")
    ApplyData queryApplyInfoById(@RequestParam("applyId") Integer applyId);
}
