package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.AssistApiHystrix;
import com.ysscale.framework.domain.Merchant;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "server-ysscale", fallback = AssistApiHystrix.class)
public interface AssistApiClient {

    @RequestMapping(value = "/ysscale/assist/checkFid", method = RequestMethod.POST)
    boolean checkFid(@RequestParam("fid") String fid);

    @RequestMapping(value = "/ysscale/assist/delUserFid", method = RequestMethod.POST)
    boolean delUserFid(@RequestParam("fid") String fid);

    @RequestMapping(value = "/ysscale/assist/checkVip", method = RequestMethod.POST)
    boolean checkVip(@RequestParam("vid") String vid);

    @RequestMapping(value = "/ysscale/assist/updateUserVip", method = RequestMethod.POST)
    boolean updateUserVip(@RequestParam("vid") String vid);

    @RequestMapping(value = "/ysscale/assist/findTUserByUserId", method = RequestMethod.POST)
    Merchant findTUserByUserId(@RequestParam("userId") Integer userId);
}
