package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.MemberApiHystrix;
import com.ysscale.framework.domain.Merchant;
import com.ysscale.framework.domain.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "server-ysscale", fallback = MemberApiHystrix.class)
public interface MemberApiClient {

    /**
     * @description: 商户手机号查询商户信息
     **/
    @RequestMapping(value = "/ysscale/member/getUserInfo", method = RequestMethod.POST)
    Merchant getUserInfo(@RequestParam("phone") String phone);

    /**
     * @description: 查询商户默认店铺信息（第一家店铺）
     **/
    @RequestMapping(value = "/ysscale/member/getDefaultStore", method = RequestMethod.POST)
    Store getDefaultStore(@RequestParam("phone") String phone);
}
