package com.ysscale.api.client;

import com.ysscale.api.client.hystrix.PublicPHystrix;
import com.ysscale.api.vo.MerchantEntry;
import com.ysscale.api.vo.QueryMSBInfo;
import com.ysscale.framework.domain.Balance;
import com.ysscale.framework.domain.Merchant;
import com.ysscale.framework.domain.Store;
import com.ysscale.framework.domain.UserStoreBalanceInfo;
import com.ysscale.framework.domain.delivery.DeviceDeliveryVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName: PublicPClient
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/2/8 10:08
 * @Version: V1.0.0
 */
@FeignClient(value = "server-ysscale", fallback = PublicPHystrix.class)
public interface PublicPClient {

    /**
     * @Description 更加设备Mac查询设备等级
     * @Author wanglie
     * @Date 10:11 2019/2/8
     **/
    @PostMapping(value = "/ysscale/publicp/getLevlByMac")
    DeviceDeliveryVo getLevlByMac(@RequestParam("mac") String mac);

    /**
     * @Description 商户账号查询商户信息
     * @Author wanglie
     * @Date 10:09 2019/2/8
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUser", method = RequestMethod.POST)
    Merchant queryUser(@RequestParam("account") String account);

    /**
     * @Description 商户账号查询店铺信息
     * @Author wanglie
     * @Date 10:11 2019/2/8
     **/
    @RequestMapping(value = "/ysscale/publicp/queryStoreByAccount", method = RequestMethod.POST)
    List<Store> queryStoreByAccount(@RequestParam("account") String account);

    /**
     * @Description 商户账号查询设备信息
     * @Author wanglie
     * @Date 10:11 2019/2/8
     **/
    @RequestMapping(value = "/ysscale/publicp/queryBalanceByAccount", method = RequestMethod.POST)
    List<Balance> queryBalanceByAccount(@RequestParam("account") String account);

    /**
     * @description: 商户编号查询所有设备信息
     **/
    @RequestMapping(value = "/ysscale/publicp/queryBalanceByUserId", method = RequestMethod.POST)
    List<Balance> queryBalanceByUserId(@RequestParam("userId") Integer userId);

    /**
     * @Description 商户店铺号查询设备信息
     * @Author wanglie
     * @Date 10:11 2019/2/8
     **/
    @RequestMapping(value = "/ysscale/publicp/queryBalanceByStore", method = RequestMethod.POST)
    List<Balance> queryBalanceByStore(@RequestParam("storeId") Integer storeId);

    /**
     * @Description 商户账号信息获取设备信息
     * @Author zhao
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserStoreBalanceByReq", method = RequestMethod.POST)
    List<UserStoreBalanceInfo> queryUserStoreBalanceByReq(@RequestParam("type") String type, @RequestParam("param") String param);

    /**
     * @description: 商户账号信息获取设备信息没有字符集
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserStoreBalanceByReqWithOutEncoding", method = RequestMethod.POST)
    List<UserStoreBalanceInfo> queryUserStoreBalanceByReqWithOutEncoding(@RequestParam("type") String type, @RequestParam("param") String param);

    /**
     * @Description 商户Id和店铺Id获取商户店铺信息
     * @Author fan
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserStoreBySidAndUid", method = RequestMethod.POST)
    UserStoreBalanceInfo queryUserStoreBySidAndUid(@RequestParam("storeId") Integer storeId, @RequestParam("userId") Integer userId);

    /**
     * @Description 商户Id获取商户信息
     * @Author fan
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserById", method = RequestMethod.POST)
    Merchant queryUserById(@RequestParam(value = "userId") Integer userId);

    /**
     * @Description 商户Id获取店铺信息
     * @Author fan
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryStoreByUserId", method = RequestMethod.POST)
    List<Store> queryStoreByUserId(@RequestParam(value = "userId") Integer userId);

    /**
     * @Description 商户标识获取商户信息
     * @Author fan
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserByUsSign", method = RequestMethod.POST)
    Merchant queryUserByUsSign(@RequestParam(value = "usSign") Long usSign);

    /**
     * @Description 店铺标识获取店铺信息
     * @Author fan
     * @Date 10:11 2019/2/26
     **/
    @RequestMapping(value = "/ysscale/publicp/queryUserById", method = RequestMethod.POST)
    Store queryStoreByStSign(@RequestParam(value = "stSign") Long stSign);

    /**
     * @description: 商户ID查询商户店铺设备列表信息
     **/
    @GetMapping(value = "/ysscale/publicp/query-msb-id")
    MerchantEntry queryMerchantStoreBalanceById(@RequestParam(value = "userId") Integer userId);

    /**
     * @description: 商户用户标识查询商户店铺设备列表信息
     **/
    @GetMapping(value = "/ysscale/publicp/query-msb-sign")
    MerchantEntry queryMerchantStoreBalanceByUserSign(@RequestParam(value = "usSign") Long usSign);

    /**
     * @description: 商户账号查询商户店铺设备列表信息
     **/
    @GetMapping(value = "/ysscale/publicp/query-msb-account")
    MerchantEntry queryMerchantStoreBalanceByAccount(@RequestParam(value = "account") String account);


    /**
     * @description: 查询商户店铺设备列表信息
     **/
    @PostMapping(value = "/ysscale/publicp/query-msb")
    MerchantEntry queryMerchantStoreBalance(@RequestBody QueryMSBInfo queryMSBInfo);
}
