package com.ysscale.api.client.hystrix;

import com.ysscale.api.client.ApiSocketServiceClient;
import com.ysscale.api.vo.UnBingInitInfo;
import com.ysscale.framework.domain.Balance;
import com.ysscale.framework.domain.order.DevicePay;
import com.ysscale.framework.domain.order.DevicePayInfo;
import com.ysscale.framework.domain.order.PayMsgInfo;
import com.ysscale.framework.domain.order.PayParameter;
import com.ysscale.framework.domain.socket.*;
import com.ysscale.framework.domain.socket.ConnectionMsg;
import com.ysscale.framework.exception.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @ProjectName: ysscale_core
 * @Package: com.yssacle.api.client.hystrix
 * @ClassName: ApiSocketServiceHystrix
 * @Description: java类作用描述
 * @Author: 王列
 * @CreateDate: 2018/5/29 10:40
 * @UpdateUser: 更新者
 * @UpdateDate: 2018/5/29 10:40
 * @UpdateRemark: 更新说明
 * @Version: 1.0
 */
@Component
public class ApiSocketServiceHystrix implements ApiSocketServiceClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApiSocketServiceHystrix.class);

    @Override
    public boolean saveBalance(@RequestBody Balance balance) {
        LOGGER.error("server-ysscale / saveBalance : 断路器异常！");
        return false;
    }

    @Override
    public boolean updateBalance(@RequestBody Balance balance) {
        LOGGER.error("server-ysscale / updateBalance : 断路器异常！");
        return false;
    }

    @Override
    public boolean saveLog(@RequestBody ResponseInstruct responseInstruct) {
        LOGGER.error("server-ysscale / saveLog : 断路器异常！");
        return false;
    }

    @Override
    public boolean saveBatchLog(List<ResponseInstruct> responseInstructs) {
        LOGGER.error("server-ysscale / saveBatchLog : 断路器异常！");
        return false;
    }

    @Override
    public boolean saveBatchLogParam(BatchLogParam batchLogParam) {
        LOGGER.error("server-ysscale / saveBatchLogParam : 断路器异常！");
        return false;
    }

    @Override
    public boolean findPaymentState(@RequestParam("deviceMac") String deviceMac) {
        LOGGER.error("server-ysscale / findPaymentState : 断路器异常！");
        return false;
    }

    @Override
    public Map<String, Object> findPayInfo(@RequestParam("deviceMac") String deviceMac) throws SystemException {
        LOGGER.error("server-ysscale / findPayInfo : 断路器异常！");
        throw new SystemException("findPayInfo : 断路器异常！");
    }

    /**
     * @param mac
     * @description: 设备Mac获取设备初始化信息
     */
    @Override
    public DeviceInitInfo getDeviceInitInfo(String mac) {
        return null;
    }

    @Override
    public void payOrder(@RequestBody PayParameter pp) {
        LOGGER.error("server-ysscale / payOrder : 断路器异常！");

    }

    @Override
    public DevicePay cancelOrder(@RequestBody PayParameter payParameter) {
        LOGGER.error("server-ysscale / cancelOrder : 断路器异常！");
        return null;
    }

    @Override
    public void refund(@RequestBody PayParameter payParameter) {
        LOGGER.error("server-ysscale / refund : 断路器异常！");

    }

    @Override
    public DevicePay cancelRefund(@RequestBody PayParameter payParameter) {
        LOGGER.error("server-ysscale / cancelRefund : 断路器异常！");
        return null;
    }

    @Override
    public boolean updateDeviceState(@RequestBody ConnectionMsg connectionMsg) {
        LOGGER.error("server-ysscale / updateDeviceState : 断路器异常！");
        return false;
    }

    @Override
    public DeviceDetail getUserByMac(String deviceMac) {
        LOGGER.error("server-ysscale / getUserByMac : 断路器异常！");
        return null;
    }

    @Override
    public PayMsgInfo getPayMsgByDevicemacAndPaycode(PayMsgInfo payMsgInfo) {
        LOGGER.error("server-ysscale / getPayMsgByDevicemacAndPaycode : 断路器异常！");
        return payMsgInfo;
    }

    @Override
    public DeviceFH getLastTimeAndFid(String mac) {
        LOGGER.error("server-ysscale / getLastTimeAndFid : 断路器异常！");
        return null;
    }

    @Override
    public DevicePayInfo checkPayInfo(String mac) {
        DevicePayInfo payInfo = new DevicePayInfo();
        payInfo.setCloudPay(false);
        payInfo.setJkyPay(false);
        return payInfo;
    }

    /**
     * @param mac
     * @description: 获取解绑信息
     */
    @Override
    public UnBingInitInfo getUnbindInfo(String mac) {
        return null;
    }
}
