package com.ysscale.api.vo;

import com.ysscale.framework.domain.Balance;
import com.ysscale.framework.domain.Store;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: StoreInfo
 * @projectName ysscale-core
 * @description: 店铺设别列表信息
 * @date 2020/7/1710:53
 */
@Data
public class StoreEntry extends Store {

    // 店铺设别列表信息
    private List<Balance> balances;

    public StoreEntry() {
        balances = new ArrayList<>();
    }

    public void addBalance(Balance balance) {
        balances.add(balance);
    }
}
