package com.ysscale.api.vo.search;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class Bill {
    // 设备ID
    private Integer balanceId;
    // 设备ID
    private String deviceMac;
    // 商铺ID
    private Integer storeId;
    // 商户ID
    private Integer userId;

    // 支付宝结算金额
    private BigDecimal alipay = new BigDecimal(0);
    // 支付宝实际金额
    private BigDecimal alipayActual = new BigDecimal(0);
    // 支付宝笔数
    private Integer alipayCount = 0;
    // 微信结算金额
    private BigDecimal weixin = new BigDecimal(0);
    // 微信实际金额
    private BigDecimal weixinActual = new BigDecimal(0);
    // 微信笔数
    private Integer weixinCount = 0;
    // 时间标志
    private String time;
    // 时间类型 BillTypeEnum
    private String timeType;
    // 账单结算时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

}