package com.ysscale.api.vo.search;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class UserRebateRecord {
    private Integer id;

    private String personId;

    private String personType;

    private String personName;

    private String personRealName;

    private String batchNo;

    private String rebateDate;

    private BigDecimal rewardAmount;// 奖励金额

    private Integer moneyType;// 金额类型

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date clearTime;

    private String state;

    private String createMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String lastupdateMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdateTime;

}