package com.ysscale.framework.domain.balance;

import com.jhscale.common.model.http.JResponse;
import com.ysscale.framework.model.pay.Payment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author lj
 * @title:
 * @projectName ysscale-core
 * @description:
 * @date 2020/11/10 9:01
 */
@ApiModel("响应安卓收银秤绑定详情（绑定状态、绑定商户相关支付信息、配置信息）")
@Data
public class AndroidBalanceBindingDetailResp extends JResponse {

    @ApiModelProperty(notes = "androidBalanceId", name = "id")
    private Integer id;

    @ApiModelProperty(notes = "安卓收银秤唯一标识", name = "uniqueId")
    private String uniqueId;

    @ApiModelProperty(notes = "安卓收银秤别名", name = "nickName")
    private String nickName;

    @ApiModelProperty(notes = "安卓收银秤绑定状态", name = "bingdingState", example = "0未绑定、1已绑定、2已解绑、3已禁用")
    private Integer bingdingState;

    @ApiModelProperty(notes = "用户ID", name = "userId")
    private Integer userId;

    @ApiModelProperty(notes = "用户编号", name = "usSign")
    private Long usSign;

    @ApiModelProperty(notes = "用户国家", name = "country")
    private String country;

    @ApiModelProperty(notes = "用户名", name = "userName")
    private String userName;

    @ApiModelProperty(notes = "用户真实姓名", name = "realName")
    private String realName;

    @ApiModelProperty(notes = "用户区号", name = "areaCode")
    private String areaCode;

    @ApiModelProperty(notes = "用户手机", name = "mobile")
    private String mobile;

    @ApiModelProperty(notes = "用户邮箱", name = "email")
    private String email;

    @ApiModelProperty(notes = "用户地区编号", name = "area")
    private String area;

    @ApiModelProperty(notes = "用户语言环境", name = "lang")
    private String lang;

    @ApiModelProperty(notes = "用户时区", name = "timeZone")
    private String timeZone;

    @ApiModelProperty(notes = "字符集", name = "encoding")
    private String encoding;

    @ApiModelProperty(notes = "微信支付", name = "payWxMchId")
    private String payWxMchId;

    @ApiModelProperty(notes = "微信支付", name = "payWxoaMchId")
    private String payWxoaMchId;

    @ApiModelProperty(notes = "支付宝支付", name = "payAliMchId")
    private String payAliMchId;

    @ApiModelProperty(notes = "支付宝支付令牌", name = "payAliToken")
    private String payAliToken;

    @ApiModelProperty(notes = "银联支付信息", name = "unionPayMap")
    private Map<String, String> unionPayMap;

    @ApiModelProperty(notes = "银联支付信息", name = "payments")
    private List<Payment> payments;

    @ApiModelProperty(notes = "云支付策略编号", name = "cloudPayStrategyId")
    private Integer cloudPayStrategyId;

    @ApiModelProperty(notes = "云支付策略", name = "cloudPayStrategy")
    private String cloudPayStrategy;

    @ApiModelProperty(notes = "店铺id", name = "storeId")
    private Integer storeId;

    @ApiModelProperty(notes = "店铺编号", name = "stSign")
    private Long stSign;

    @ApiModelProperty(notes = "店铺名称", name = "storeName")
    private String storeName;

    @ApiModelProperty(notes = "店铺SID", name = "storeSid")
    private String storeSid;

    @ApiModelProperty(notes = "店铺地区", name = "storeArea")
    private String storeArea;

    @ApiModelProperty(notes = "店铺地址", name = "storeAddress")
    private String storeAddress;

    @ApiModelProperty(notes = "经度", name = "lng")
    private BigDecimal lng;

    @ApiModelProperty(notes = "纬度", name = "lat")
    private BigDecimal lat;

    @ApiModelProperty(notes = "管理员编号", name = "adminId")
    private String adminId;


    @ApiModelProperty(notes = "经销商ID", name = "agentId")
    private Integer agentId;

    @ApiModelProperty(notes = "经销商业务标识", name = "agSign")
    private Long agSign;

    @ApiModelProperty(notes = "经销商名称", name = "agentName")
    private String agentName;

    @ApiModelProperty(notes = "经销商地区编号", name = "agentArea")
    private String agentArea;

    @ApiModelProperty(notes = "经销商地址", name = "agentAddress")
    private String agentAddress;

    @ApiModelProperty(notes = "区号", name = "agentAreaCode")
    private String agentAreaCode;

    @ApiModelProperty(notes = "经销商联系电话", name = "agentMobile")
    private String agentMobile;


    @ApiModelProperty(notes = "删除状态", name = "onlineState", example = "0-正常，1-删除")
    private String state;


    @ApiModelProperty(notes = "心跳间隔 （秒）", name = "heartbeatIntervalSecond")
    private Integer heartbeatIntervalSecond;
}
