package com.ysscale.framework.domain.balance;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApiBalanceVo {
    private Integer id;

    private String deviceMac;

    private String deviceName;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bingdingTime;

    private String icon;

    private String trademark;

    private String sFid;

    private Integer storeId;

    private String onlineState;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastConectionTime;

    private String version;

    private String state;

    private String createMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String lastupdateMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdateTime;

    private String encoding;

    private String remark1;

    private String remark2;

    private String remark3;

    private String remark4;

    private Integer bingdingState;

    private String cpuVersion;

    private String androidVersion;

    private String appVersion;

    private Integer balanceType;

}