package com.ysscale.framework.domain.balance;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceVo {
    private Integer id;

    private String deviceMac;

    private String deviceId;

    private String fTick;

    private String bTime;

    private String random;

    private String aesKey;

    private String version;

    private Integer timeZone;

    private Integer boundState;

    private String encoding;

    private String onlineType;

    private String fid;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastHeat;

    private String timeInterval;

    private String state;

    private String createMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String lastupdateMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdateTime;

    private String remark1;

    private String remark2;

    private String remark3;

    private String remark4;

    private String serialNo;

    private String anroidVersion;

    private String systemVersion;

    private String kernelVersion;

    private String apiVersion;

    private String wifiMac;

    private String ethernetMac;

    private String cpuVersion;

    private Long memoryCapacity;

    private Long memoryUsageCapacity;

    private Long diskCapacity;

    private Long diskUseageCapacity;

    private Long sdDiskCapacity;

    private Long sdDiskUseageCapacity;

    private String ivKey;

    private Integer deviceType;

}