package com.ysscale.framework.domain.balance;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SocketBalanceVo {
    private Integer id;

	@ApiModelProperty(value = "批次号", name = "batchNo")
    private String batchNo;

	@ApiModelProperty(value = "mac", name = "mac")
    private String mac;

	@ApiModelProperty(value = "mac计数量", name = "macCount")
    private Integer macCount;

	@ApiModelProperty(value = "使用状态(0-未使用,1-已使用,2-已锁定)", name = "employState")
    private String employState;

	@ApiModelProperty(value = "出厂日期(生成密匙日期)", name = "releaseDate")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseDate;

	@ApiModelProperty(value = "fid", name = "fid")
    private String fid;

	@ApiModelProperty(value = "设备类型(0-普通收银秤,1-安卓收银秤,2-蓝牙吊秤,6-汽车衡)", name = "balanceType")
    private String balanceType;

	@ApiModelProperty(value = "设备出厂密匙", name = "balanceReleaseKey")
    private String balanceReleaseKey;

	@ApiModelProperty(value = "设备信息", name = "balanceInfo")
    private String balanceInfo;

	@ApiModelProperty(value = "备注信息", name = "remarkInfo")
    private String remarkInfo;

	@ApiModelProperty(value = "经销商业务标识", name = "agentSign")
    private Long agentSign;

	@ApiModelProperty(value = "经销商信息", name = "agentInfo")
    private String agentInfo;

	@ApiModelProperty(value = "在线状态", name = "onlineState")
    private String onlineState;

	@ApiModelProperty(value = "上次使用时间(获取密匙时间)", name = "lastTimeUse")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastTimeUse;

	@ApiModelProperty(value = "使用设备商户业务编号", name = "balanceUseMerchantSign")
    private Long balanceUseMerchantSign;

	@ApiModelProperty(value = "设备上传方式(0-手动上传,1-自动上传)", name = "balanceUploadWay")
    private Integer balanceUploadWay;

	@ApiModelProperty(value = "自动上传 间隔时间 min", name = "autoUploadIntervalTime")
    private Integer autoUploadIntervalTime;

    private Integer remark1;

    private String remark2;

    private String remark3;

    private String remark4;

    private String state;

    private String createMan;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String lastupdateMan;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdateTime;

	@ApiModelProperty(value = "用户业务编号", name = "上次使用设备商户终端信息")
	private String balanceLastTimeMerchantInfo;

	private String remark5;

}