package com.ysscale.framework.domain.delivery;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @author lie_w
 * @title: DiffSocketServer
 * @projectName ysscale-core
 * @description: 跨服务测试设备
 * @date 2019/12/1817:53
 */
@Data
public class DiffSocketServer implements Serializable {

    @ApiModelProperty(value = "唯一标识", name = "sgin", required = true)
    private String sgin;

    @ApiModelProperty(value = "测试IP", name = "ip", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private String ip;

    @ApiModelProperty(value = "Socket Port", name = "port", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private int port;

    @ApiModelProperty(value = "内网IP", name = "sip", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private String sip;

    @ApiModelProperty(value = "Server Port", name = "svport", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private int svport;
}
