package com.ysscale.framework.domain.delivery;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @author lie_w
 * @title: SocketServer
 * @projectName ysscale-core
 * @description: Socket 服务设备端口号
 * @date 2019/12/1816:15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SocketServer implements Serializable {

    @ApiModelProperty(value = "测试类型", name = "testType", required = true, example = "线下测试|同服务线上测试|跨服务线上测试")
    private TestTypeEnum testType;

    @ApiModelProperty(value = "MAC", name = "mac")
    private String mac;

    @ApiModelProperty(value = "商户ID", name = "userId")
    private String userId;

    @ApiModelProperty(value = "测试IP", name = "ip", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private String ip;

    @ApiModelProperty(value = "Socket Port", name = "port", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private int port;

    @ApiModelProperty(value = "内网IP", name = "sip", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private String serverip;

    @ApiModelProperty(value = "Server Port", name = "svport", required = true)
    @NotEmpty(message = "the type cannot be empty")
    private int serverPort;

}
