package com.ysscale.framework.domain.order;

import com.ysscale.framework.orderem.DeviceHandleStateEnum;
import com.ysscale.framework.orderem.OrderPayTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: DevicePay
 * @projectName ysscale-core
 * @description: TODO
 * @date 2019/10/823:13
 */
@Data
public class DevicePay implements Serializable {

    // 查询时间
    private long queryTime = System.currentTimeMillis();
    // 设备MAC
    private String mac;
    // 支付码
    private String payCode;
    // 订单kid
    private String systemOrderId;
    // 第三方返回订单ID
    private String trandId;
    // 失败返回码
    private String errCode;
    // 失败返回信息
    private String errMsg;
    // 支付类型
    private OrderPayTypeEnum payType;
    // 处理状态  OK ：支付成功  NO:支付失败  WT:支付暂时未有结果
    private DeviceHandleStateEnum handleState;
    // 支付金额
    private BigDecimal money;
    // 设备编码方式
    private String encoding;
    // cmd片段
    private String content;
    // 设备密钥
    private String deviceKey;
    // 设备NID
    private String nid;
    // FID
    private String fid;
    // socket ip port
    private String ipPort;
    // socket uniqueKey
    private String uniqueKey;

    public String getHeatKey() {
        return this.mac + this.payCode;
    }
}
