package com.ysscale.framework.domain.order;

import com.ysscale.framework.model.pay.BalancePayInfo;
import com.ysscale.framework.model.pay.MerchantPayInfo;
import com.ysscale.framework.model.pay.StorePayInfo;
import com.ysscale.framework.model.pay.TradeParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: PayParameter
 * @projectName ysscale-core
 * @description: TODO
 * @date 2019/10/823:12
 */
@Data
public class PayParameter extends TradeParameter {

    // 设备Mac
    private String mac;

    // fid
    private String fid;

    // NID
    private String nid;

    // 支付码（支付） 单号（退款）
    private String payCode;

    // 金额 以分为单位
    private BigDecimal money;

    // 商品名称
    private String goodsName;

    // 商品数量
    private Integer goodsNumber;

    // 重复次数
    private int repeatNumber;

    // 商户支付信息
    private MerchantPayInfo merchantPayInfo;

    // 店铺支付信息
    private StorePayInfo storePayInfo;

    // 设备信息
    private BalancePayInfo balancePayInfo;

    public String redisKey() {
        return this.mac + this.payCode;
    }
}
