package com.ysscale.framework.domain.order;

import com.ysscale.framework.orderem.DeviceHandleStateEnum;
import com.ysscale.framework.orderem.OrderPayTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 支付信息
 */
@Data
public class TradeInfo {

    // 微信或支付宝流水号【传递】
    private String tradeNo;
    // 支付服务商返回之际支付金额【传递】
    private BigDecimal actualMoney;
    // 交易状态【传递】
    private DeviceHandleStateEnum handleState;
    // 支付方式【传递】
    private OrderPayTypeEnum payWay;

    // 错误码
    private String errCode;
    // 错误信息
    private String errMsg;
    // 订单支付总金额
    private BigDecimal money;
    // 设备编号
    private Integer balanceId;
    // 支付码
    private String code;
    // 本系统订单编号
    private String orderNo;
    // 商品标题信息（商品名称）
    private String title;
    // 现在该字段标识的是支付宝商家的 pid
    private String payAliToken;
    // 微信MID
    private String payWxMchId;
    // 订单失效信息
    private int closeTime;
    // 商户ID
    private String userId;
    // 商铺ID
    private String storeId;
    // 商铺 sid
    private String storeSid;
    // 设备MAC
    private String mac;

    // 账单日期
    private String billDate;
    // 账单类型
    private String billType;

    // 订单创建时间，作为清算时间
    private Date createTime;
    // 支付成功时间
    private Date successTime;
    //商品种数
    private Integer goodsNumber;

    // 时区
    private String timeZone;
}
