package com.ysscale.framework.domain.pay;

import com.jhscale.common.model.http.JRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author lie_w
 * @title: BasePaymentRequest
 * @projectName ysscale-core
 * @description: TODO
 * @date 2021/4/229:07
 */
@Data
@ApiModel("基础云支付订单请求")
public class BasePaymentRequest extends JRequest {

    @ApiModelProperty(value = "设备类型(不传默认 Simple_Scales)", name = "type", example = "Simple_Scales|Android_Scales|PC_Scales|BT_Scales|VPS_PC_Scales")
    private String type;

    @ApiModelProperty(value = "设备编号", name = "unique", required = true)
    @NotEmpty(message = "设备编号不能为空")
    private String unique;

    @ApiModelProperty(value = "重试次数 默认0 请求若无响应+1（非必填,若不填后台首次判断基于(unique+fid),填写后台判断基于重试次数（性能更优））", name = "repeat")
    private Integer repeat;

    @ApiModelProperty(value = "设备记录编号（HEX）", name = "fid", required = true)
    @NotEmpty(message = "设备记录编号不能为空")
    private String fid;

    @ApiModelProperty(value = "标题(默认第一个商品名)，不传则默认 临时商品", name = "title")
    private String title;

    @ApiModelProperty(value = "明细数量", name = "count", required = true)
    @NotEmpty(message = "明细数量不能为空")
    private Integer count;

    @ApiModelProperty(value = "订单支付金额 >0 (小数点位数不传 默认分)", name = "amount", required = true)
    @NotNull(message = "订单支付金额不能为空")
    private Integer amount;

    @ApiModelProperty(value = "小数点位数", name = "decimalPoint")
    private Integer ponit = 2;

    @ApiModelProperty(value = "订单创建时间 (秤上时间 不需要自传时区 不传默认当前时间)（yyyy-MM-dd HH:mm:ss）", name = "start")
    private String start;
}
