package com.ysscale.framework.domain.pay;

import com.ysscale.framework.orderem.DeviceHandleStateEnum;
import com.ysscale.framework.orderem.OrderPayStateEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @title: PayOrderCompleteVo
 * @projectName: ysscale-core
 * @description: TODO
 * @author: 刘腾
 * @date: 2021/3/11  12:47
 */
@Data
@ApiModel
public class PayOrderCompleteVo {

    /**
     * 设备唯一编号
     */
    @ApiModelProperty(value = "当期设备编号", name = "unique", required = true)
    private String unique;

    /**
     * 支付码
     **/
    @ApiModelProperty(value = "付款码", name = "payCode")
    private String payCode;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "系统单号", name = "orderNo")
    private String orderNo;

    /**
     * 支付单号
     */
    @ApiModelProperty(value = "支付单号", name = "tradeNo")
    private String tradeNo;

    /**
     * 支付状态
     */
    @ApiModelProperty(value = "支付状态", name = "payState")
    private Integer payState;

    /**
     * 实际支付金额
     */
    @ApiModelProperty(value = "实际支付金额", name = "actualFee")
    private Integer actualFee;

    /**
     * 错误码
     */
    @ApiModelProperty(value = "错误码", name = "errCode")
    private String errCode;

    /**
     * 错误信息
     */
    @ApiModelProperty(value = "错误信息", name = "errMsg")
    private String errMsg;

    @ApiModelProperty(value = "支付成功状态", name = "waitType")
    private String waitType;
}
