package com.ysscale.framework.domain.pay;

import com.jhscale.common.em.DeviceType;
import com.ysscale.framework.entity.JHRequest;
import com.ysscale.framework.orderem.OrderPayTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @title: PayOrderVo
 * @projectName: ysscale-core
 * @description: 支付订单请求参数
 * @author: 刘腾
 * @date: 2021/3/10  12:41
 */
@Data
@ApiModel("支付参数入参")
public class PayOrderVo extends JHRequest {

    /**
     * 支付码
     **/
    @ApiModelProperty(value = "支付码", name = "payCode", required = true)
    @NotEmpty(message = "支付码不能为空")
    private String payCode;

    /**
     * 支付金额 -- 分
     **/
    @ApiModelProperty(value = "订单支付金额", name = "orderAmount", required = true)
    @NotNull(message = "订单支付金额不能为空")
    private Integer totalAmount;

    /**
     * 小数点位数
     */
    @ApiModelProperty(value = "小数点位数", name = "decimalPoint")
    private Integer ponit = 2;

    /**
     * fid 当前和第三方支付单号
     */
    @ApiModelProperty(value = "fid", name = "fid")
    @NotEmpty(message = "不能为空")
    private String fid;

    /**
     * 设备唯一编号
     */
    @ApiModelProperty(value = "当期设备编号", name = "deviceUnique", required = true)
    @NotEmpty(message = "当期设备编号不能为空")
    private String unique;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型", name = "deviceType")
    private String deviceType;

    /**
     * 系统单号
     */
    @ApiModelProperty(value = "系统单号", name = "orderNo")
    private String orderNo;

    /**
     * 标题
     **/
    @ApiModelProperty(value = "标题", name = "title", required = true)
    @NotEmpty(message = "标题不能为空")
    private String title;

    /**
     * 数量
     */
    @ApiModelProperty(value = "数量", name = "count", required = true)
    @NotEmpty(message = "数量不能为空")
    private Integer count;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createDate")
    private String createDate;


}
