package com.ysscale.framework.domain.report;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @program: ysscale_core
 * @description:
 * @author: zhao
 * @create: 2019-04-08 09:41
 **/
@Data
public class RakebackPlan {
    private Integer id;

    private String planName;

    private Integer agentId;

    private String agentName;

    private BigDecimal userRakebackAliRation;

    private BigDecimal userRakebackWxiRation;

    private BigDecimal agent1RakebackAliRation;

    private BigDecimal agent1RakebackWxiRation;

    private Integer agent2Id;

    private String agent2Name;

    private BigDecimal agent2RakebackAliRation;

    private BigDecimal agent2RakebackWxiRation;

    private Integer agent3Id;

    private String agent3Name;

    private BigDecimal agent3RakebackAliRation;

    private BigDecimal agent3RakebackWxiRation;

    private String state;

    private String createMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String lastupdateMan;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastupdateTime;
}
