package com.ysscale.framework.domain.socket;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ysscale.framework.utils.Base64Utils;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @title: BananceBatchLogParam
 * @projectName: ysscale-core-20201118
 * @description: TODO
 * @author: 刘腾
 * @date: 2020/12/15  8:52
 */
@Data
public class BananceBatchLogParam {

    private List<ResponseInstruct> responsesInstructs;

    private Integer userId;

    private Long usSign;

    private String userName;

    private Integer storeId;

    private Long stSign;

    private String storeName;

    private Integer balanceId;

    private String balanceName;

    private String mac;

    private String encoding;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date heatTime;

    private String fid;

    private String timeZone;


    @Data
    public static class ResponseInstruct{
        private String mac;

        private String nid;

        private String dcmd;

        private String dsort;

        private String did;

        private String ddata;

        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
        private Date reviseTime;

        private String logType;

        public ResponseInstruct(String mac, String nid, String dcmd, String dsort, String did, String ddata) {
            this.mac = mac;
            this.nid = nid;
            this.dcmd = dcmd;
            this.dsort = dsort;
            this.did = did;
            this.ddata = ddata;
        }

        public ResponseInstruct(String mac, String dcmd, String dsort, String did, String ddata) {
            this.mac = mac;
            this.dcmd = dcmd;
            this.dsort = dsort;
            this.did = did;
            this.ddata = Base64Utils.gzipString(ddata);
        }

        public ResponseInstruct() {
        }
    }

}
