package com.ysscale.framework.domain.socket;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ysscale.framework.em.socket.DeviceLineStateEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lie_w
 * @title: ConnectionMsg
 * @projectName ysscale-core
 * @description: TODO
 * @date 2019/10/823:15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ConnectionMsg implements Serializable {

    private String mac;

    private DeviceLineStateEnum lineState;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    @Deprecated
    private String fid;

    public ConnectionMsg(String mac, DeviceLineStateEnum lineState, Date time) {
        this.mac = mac;
        this.lineState = lineState;
        this.time = time;
    }
}
