package com.ysscale.framework.domain.socket;

import com.ysscale.framework.em.socket.DeviceCashEnum;
import com.ysscale.framework.entity.JHRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lie_w
 * @title: DeviceCashReset
 * @projectName ysscale-core
 * @description: TODO
 * @date 2020-08-2412:35
 */
@ApiModel("设备缓存重置")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceCashReset extends JHRequest {

    @ApiModelProperty(value = "设备列表", name = "macs")
    private String macs;

    @ApiModelProperty(value = "设备缓存信息，不填清空全部配置", name = "cashType")
    private DeviceCashEnum cashType;

    @ApiModelProperty(value = "是否通知设备下线 默认通知", name = "clearAndBreakSocket")
    private boolean clearAndBreakSocket = true;

    public DeviceCashReset(String macs, DeviceCashEnum cashType) {
        this.macs = macs;
        this.cashType = cashType;
    }
}
