package com.ysscale.framework.domain.socket;

import com.ysscale.framework.em.DataStateEnum;
import com.ysscale.framework.em.SwitchState;
import com.ysscale.framework.em.socket.DeviceConfigEnum;
import com.ysscale.framework.entity.JHRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lie_w
 * @title: DeviceConfigRequest
 * @projectName ysscale-core
 * @description: TODO
 * @date 2020-08-0416:17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceConfigRequest extends JHRequest {

    @ApiModelProperty(value = "设备功能", name = "funcation")
    private DeviceConfigEnum funcation;

    @ApiModelProperty(value = "开关功能", name = "switchState")
    private SwitchState switchState = SwitchState.启用;

    @ApiModelProperty(value = "状态功能", name = "dataState")
    private DataStateEnum dataState = DataStateEnum.NORMAL;
}
