package com.ysscale.framework.domain.socket;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ysscale.framework.model.pay.Payment;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @ClassName: DeviceInfo
 * @Desprition: TODO
 * @Auth: lie_w
 * @Date: 2019/1/3 13:46
 * @Version: V1.0.0
 */
@Data
public class DeviceInfo implements Serializable {

    // 设备编号
    private Integer balanceId;

    private String mac;

    // 设备别名
    private String balanceName;

    // 设备版本
    private String version;

    // 设备经销商
    private String trademark;

    private String encoding;

    private String coding;

    // 时区
    private String timeZone;

    private String onlineType;

    private String deviceId;

    private String ftick;

    private String btime;

    private String random;

    private String aesKey;

    // 绑定状态
    private Integer boundState;

    // 绑定时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bingdingTime;

    // 时间间隔
    private String timeInterval;

    // 设备类型
    private Integer deviceType;

    // 设备SIMID
    private String simId;


    // 商户ID
    private Integer userId;

    private Long usSign;

    // 国家
    private String country;

    // 商户名称
    private String userName;

    // 真实姓名
    private String realName;

    // 用户区号
    private String areaCode;

    // 手机号码
    private String mobile;

    // 电子邮箱
    private String email;

    // 地区编号
    private String area;

    // 语言环境
    private String lang;

    // 微信支付
    private String payWxMchId;

    // 支付宝支付
    private String payAliMchId;

    // 支付宝支付令牌
    private String payAliToken;

    // 银联支付信息
    private Map<String, String> unionPayMap;

    // 云支付策略编号
    private Integer cloudPayStrategyId;

    // 云支付策略
    private String cloudPayStrategy;

    // 支付全信息
    private List<Payment> payments;

    // 店铺编号
    private Integer storeId;

    private Long stSign;

    // 店铺名称
    private String storeName;

    // 店铺SID
    private String storeSid;

    // 店铺地区
    private String storeArea;

    // 店铺地址
    private String storeAddress;

    // 管理员编号
    private String adminId;

    // 经销商ID
    private Integer agentId;

    // 经销商业务标识
    private Long agSign;

    // 经销商名称
    private String agentName;

    // 经销商地区编号
    private String agentArea;

    //经销商地址
    private String agentAddress;

    // 区号
    private String agentAreaCode;

    // 手机联系方式
    private String agentMobile;
}
