package com.ysscale.framework.domain.socket;

import com.ysscale.framework.em.DataStateEnum;
import com.ysscale.framework.em.SwitchState;
import com.ysscale.framework.em.socket.DeviceConfigEnum;
import com.ysscale.framework.entity.JHRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: DeviceConfigRequest
 * @projectName ysscale-core
 * @description: TODO
 * @date 2020-08-0414:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DevicesConfigRequest extends JHRequest {

    @ApiModelProperty(value = "设备列表", name = "macs")
    private List<String> macs;

    @ApiModelProperty(value = "设备功能", name = "funcation")
    private DeviceConfigEnum funcation;

    @ApiModelProperty(value = "设备功能字符", name = "functionStr")
    private String functionStr;

    @ApiModelProperty(value = "开关功能", name = "switchState")
    private SwitchState switchState = SwitchState.启用;

    @ApiModelProperty(value = "开关功能字符", name = "switchStr")
    private String switchStr;

    @ApiModelProperty(value = "状态功能", name = "dataState")
    private DataStateEnum dataState = DataStateEnum.NORMAL;

    @ApiModelProperty(value = "开关功能字符", name = "dataStr")
    private String dataStr;

    /**
     * @description: 添加MAC
     **/
    public void addMac(String mac) {
        if (Objects.isNull(mac)) macs = new ArrayList<>();
        macs.add(mac);
    }

}
