package com.ysscale.framework.domain.socket;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ysscale.framework.utils.Base64Utils;
import lombok.Data;

import java.util.Date;

/**
 * @author lie_w
 * @title: ResponseInstruct
 * @projectName ysscale-core
 * @description: TODO
 * @date 2019/10/823:03
 */
@Data
public class ResponseInstruct {

    private String mac;

    private String nid;

    private String dcmd;

    private String dsort;

    private String did;

    private String ddata;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date reviseTime;

    private String logType;

    public ResponseInstruct(String mac, String nid, String dcmd, String dsort, String did, String ddata) {
        this.mac = mac;
        this.nid = nid;
        this.dcmd = dcmd;
        this.dsort = dsort;
        this.did = did;
        this.ddata = ddata;
    }

    public ResponseInstruct(String mac, String dcmd, String dsort, String did, String ddata) {
        this.mac = mac;
        this.dcmd = dcmd;
        this.dsort = dsort;
        this.did = did;
        this.ddata = Base64Utils.gzipString(ddata);
    }

    public ResponseInstruct() {
    }
}
