package com.ysscale.framework.domain.store;

import com.jhscale.common.model.http.JRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author: zl
 * @date: 2021/12/17 0017 8:43
 **/
@ApiModel("查询店铺扩展参数")
@Data
public class StoreExtendReq  extends JRequest {

    @NotNull(message = "店铺id不能为空")
    @ApiModelProperty(value = "店铺id", name = "storeId", required = true)
    private Integer storeId;

    @ApiModelProperty(value = "店铺扩展参数key", name = "storeKeyList")
    private List<String> storeKeyList;

}
