package com.ysscale.framework.em.api;

/**
 * @author lj
 * @title:
 * @projectName ysscale-core
 * @description: 经销商参数枚举
 * @date 2021/7/20 12:25
 */
public enum AgentParamEnum {
    域名("1", "domain"),
    子账号数量("2", "maxSub"),

    ;

    //参数编号
    private String key;
    //参数名
    private String name;

    AgentParamEnum(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }


    public static AgentParamEnum key(String key) {
        for (AgentParamEnum paramEnum : AgentParamEnum.values()) {
            if (paramEnum.getKey().equals(key)) {
                return paramEnum;
            }
        }
        return null;
    }
}
