package com.ysscale.framework.em.api;

import lombok.extern.slf4j.Slf4j;

/**
 * @author lj
 * @title:
 * @projectName ysscale-core
 * @description: 商户参数枚举
 * @date 2021/7/20 12:25
 */
@Slf4j
public enum UserParamEnum {
    域名("1","domain"),
    子账号数量("2","maxSub"),

    ;

    //参数编号
    private String key;
    //参数名
    private String name;

    UserParamEnum(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public static UserParamEnum key(String key){
        for (UserParamEnum value : UserParamEnum.values()) {
            if(value.getKey().equals(key)){
                return value;
            }
        }
        log.error("UserParamEnum key "+key+" 无匹配参数");
        return null;
    }
}
