package com.ysscale.framework.em.socket;

/**
 * @author Loveven
 * @title: CMDResultType
 * @projectName ysscale-core
 * @description: 数据处理结果枚举
 * @date 2019/9/149:45
 */
public enum CMDResultType {

    /**
     * 指令响应结果
     */
    成功("00", "成功"),
    CRC不通过("01", "CRC不通过"),
    存在不合法流格式("02", "存在不合法流格式"),
    存在DSort不被接受("03", "存在DSort不被接受"),
    存在D_ID不被接受("04", "存在D-ID不被接受"),
    存在D_Data不被接受("05", "存在D-Data不被接受"),
    秤忙碌中_不接受新指令("06", "秤忙碌中，不接受新指令"),

    数据流缓冲正常数据("10", "数据流缓冲正常数据"),

    /**
     * 数据业务下发结果
     */
    数据执行中("40", "数据执行中"),
    离线保存成功("41", "离线保存成功"),
    设备在线("42", "设备在线"),
    设备离线("43", "设备离线"),
    数据发送失败转离线("44", "数据发送失败转离线"),
    离线保存失败("45", "离线保存失败"),
    离线设备又转在线("46", "离线设备又转在线"),
    数据未被找到或已失效("47", "数据未被找到或已失效"),
    设备存在未处理离线数据("48", "设备存在未处理离线数据"),
    设备离线数据流数量达到上限("49", "设备离线数据流数量达到上限"),
    数据缓冲发送("50", "数据缓冲发送"),

    /**
     * 日志数据
     */
    日志数据("60", "日志数据");


    private String code;

    private String msg;

    CMDResultType(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
