package com.ysscale.framework.em.socket;

import java.util.Objects;

/**
 * @ProjectName: ysscale
 * @Package: com.ysscale.common.enm
 * @ClassName: BindingStateEnum
 * @Description: java类作用描述
 * @Author: 王列
 * @CreateDate: 2018/4/12 15:28
 * @UpdateUser: 更新者
 * @UpdateDate: 2018/4/12 15:28
 * @UpdateRemark: 更新说明
 * @Version: 1.0
 */
public enum DeviceBindingStateEnum {

    UNBINDING(0), BINDING(1);

    private int state;

    DeviceBindingStateEnum(int state) {
        this.state = state;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    /**
     * @description: 获取绑定状态
     **/
    public static DeviceBindingStateEnum bindingState(Integer state) {
        if (Objects.nonNull(state)) {
            for (DeviceBindingStateEnum deviceBindingStateEnum : DeviceBindingStateEnum.values()) {
                if (deviceBindingStateEnum.getState() == state) return deviceBindingStateEnum;
            }
        }
        return UNBINDING;
    }

    @Override
    public String toString() {
        return String.valueOf(this.state);
    }
}
